/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.quickfixj.CharsetSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.FileUtil;
import quickfix.MemoryStore;
import quickfix.MessageStore;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class CachedFileStore
implements MessageStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String READ_OPTION = "r";
    private static final String WRITE_OPTION = "w";
    private static final String SYNC_OPTION = "d";
    private static final String NOSYNC_OPTION = "";
    private final MemoryStore cache = new MemoryStore();
    private final String msgFileName;
    private final String headerFileName;
    private final String seqNumFileName;
    private final String sessionFileName;
    private RandomAccessFile messageFileReader;
    private RandomAccessFile messageFileWriter;
    private DataOutputStream headerDataOutputStream;
    private RandomAccessFile sequenceNumberFile;
    private final boolean syncWrites;
    private final CachedHashMap messageIndex = new CachedHashMap(100);
    private FileOutputStream headerFileOutputStream;

    CachedFileStore(String path, SessionID sessionID, boolean syncWrites) throws IOException {
        this.syncWrites = syncWrites;
        String fullPath = new File(path == null ? "." : path).getAbsolutePath();
        String sessionName = FileUtil.sessionIdFileName(sessionID);
        String prefix = FileUtil.fileAppendPath(fullPath, sessionName + ".");
        this.msgFileName = prefix + "body";
        this.headerFileName = prefix + "header";
        this.seqNumFileName = prefix + "seqnums";
        this.sessionFileName = prefix + "session";
        File directory = new File(this.msgFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.initialize(false);
    }

    void initialize(boolean deleteFiles) throws IOException {
        this.closeFiles();
        if (deleteFiles) {
            this.deleteFiles();
        }
        this.messageFileWriter = new RandomAccessFile(this.msgFileName, this.getRandomAccessFileOptions());
        this.messageFileReader = new RandomAccessFile(this.msgFileName, READ_OPTION);
        this.sequenceNumberFile = new RandomAccessFile(this.seqNumFileName, this.getRandomAccessFileOptions());
        this.initializeCache();
    }

    private void initializeCache() throws IOException {
        this.cache.reset();
        this.initializeMessageIndex();
        this.initializeSequenceNumbers();
        this.initializeSessionCreateTime();
        this.messageFileWriter.seek(this.messageFileWriter.length());
    }

    private void initializeSessionCreateTime() throws IOException {
        block15: {
            File sessionTimeFile = new File(this.sessionFileName);
            if (sessionTimeFile.exists() && sessionTimeFile.length() > 0L) {
                try (DataInputStream sessionTimeInput = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionTimeFile)));){
                    Calendar c = SystemTime.getUtcCalendar(UtcTimestampConverter.convert(sessionTimeInput.readUTF()));
                    this.cache.setCreationTime(c);
                    break block15;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.storeSessionTimeStamp();
        }
    }

    private void storeSessionTimeStamp() throws IOException {
        try (DataOutputStream sessionTimeOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.sessionFileName, false)));){
            Date date = SystemTime.getDate();
            this.cache.setCreationTime(SystemTime.getUtcCalendar(date));
            sessionTimeOutput.writeUTF(UtcTimestampConverter.convert(date, true));
        }
    }

    @Override
    public Date getCreationTime() throws IOException {
        return this.cache.getCreationTime();
    }

    private void initializeSequenceNumbers() throws IOException {
        this.sequenceNumberFile.seek(0L);
        if (this.sequenceNumberFile.length() > 0L) {
            String s = this.sequenceNumberFile.readUTF();
            int offset = s.indexOf(58);
            if (offset < 0) {
                throw new IOException("Invalid sequenceNumbderFile '" + this.seqNumFileName + "' character ':' is missing");
            }
            this.cache.setNextSenderMsgSeqNum(Integer.parseInt(s.substring(0, offset)));
            this.cache.setNextTargetMsgSeqNum(Integer.parseInt(s.substring(offset + 1)));
        }
    }

    private void initializeMessageIndex() throws IOException {
        File headerFile = new File(this.headerFileName);
        if (headerFile.exists()) {
            try (DataInputStream headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));){
                while (headerDataInputStream.available() > 0) {
                    int sequenceNumber = headerDataInputStream.readInt();
                    long offset = headerDataInputStream.readLong();
                    int size = headerDataInputStream.readInt();
                    this.messageIndex.put(Long.valueOf(sequenceNumber), new long[]{offset, size});
                }
            }
        }
        this.headerFileOutputStream = new FileOutputStream(this.headerFileName, true);
        this.headerDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.headerFileOutputStream));
    }

    private String getRandomAccessFileOptions() {
        return "rw" + (this.syncWrites ? SYNC_OPTION : NOSYNC_OPTION);
    }

    public void closeFiles() throws IOException {
        this.closeOutputStream(this.headerDataOutputStream);
        this.closeFile(this.messageFileWriter);
        this.closeFile(this.messageFileReader);
        this.closeFile(this.sequenceNumberFile);
    }

    private void closeFile(RandomAccessFile file) throws IOException {
        if (file != null) {
            file.close();
        }
    }

    private void closeOutputStream(OutputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public void deleteFiles() throws IOException {
        this.closeFiles();
        this.deleteFile(this.headerFileName);
        this.deleteFile(this.msgFileName);
        this.deleteFile(this.seqNumFileName);
        this.deleteFile(this.sessionFileName);
    }

    private void deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && !file.delete()) {
            this.log.error("File delete failed: {}", (Object)fileName);
        }
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.cache.getNextSenderMsgSeqNum();
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.cache.getNextTargetMsgSeqNum();
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.cache.setNextSenderMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.cache.setNextTargetMsgSeqNum(next);
        this.storeSequenceNumbers();
    }

    @Override
    public void incrNextSenderMsgSeqNum() throws IOException {
        this.cache.incrNextSenderMsgSeqNum();
        this.storeSequenceNumbers();
    }

    @Override
    public void incrNextTargetMsgSeqNum() throws IOException {
        this.cache.incrNextTargetMsgSeqNum();
        this.storeSequenceNumbers();
    }

    @Override
    public void get(int startSequence, int endSequence, Collection<String> messages) throws IOException {
        Collection<String> readedMsg = this.getMessage(startSequence, endSequence);
        messages.addAll(readedMsg);
    }

    public boolean get(int sequence, String message) {
        throw new UnsupportedOperationException("not supported");
    }

    private String read(long offset, int size) throws IOException {
        try {
            byte[] data = new byte[size];
            this.messageFileReader.seek(offset);
            this.messageFileReader.readFully(data);
            return new String(data, CharsetSupport.getCharset());
        }
        catch (EOFException eofe) {
            throw new IOException("Truncated input while reading message: offset=" + offset + ", expected size=" + size, eofe);
        }
    }

    private Collection<String> getMessage(long startSequence, long endSequence) throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        List<long[]> offsetAndSizes = this.messageIndex.get(startSequence, endSequence);
        for (long[] offsetAndSize : offsetAndSizes) {
            if (offsetAndSize == null) continue;
            String message = this.read(offsetAndSize[0], (int)offsetAndSize[1]);
            messages.add(message);
        }
        this.messageFileReader.seek(this.messageFileReader.length());
        return messages;
    }

    @Override
    public boolean set(int sequence, String message) throws IOException {
        long offset = this.messageFileWriter.getFilePointer();
        byte[] messageBytes = message.getBytes(CharsetSupport.getCharset());
        int size = messageBytes.length;
        this.messageIndex.put(Long.valueOf(sequence), new long[]{offset, size});
        this.headerDataOutputStream.writeInt(sequence);
        this.headerDataOutputStream.writeLong(offset);
        this.headerDataOutputStream.writeInt(size);
        this.headerDataOutputStream.flush();
        if (this.syncWrites) {
            this.headerFileOutputStream.getFD().sync();
        }
        this.messageFileWriter.write(messageBytes);
        return true;
    }

    private void storeSequenceNumbers() throws IOException {
        this.sequenceNumberFile.seek(0L);
        this.sequenceNumberFile.writeUTF(NOSYNC_OPTION + this.cache.getNextSenderMsgSeqNum() + ':' + this.cache.getNextTargetMsgSeqNum());
    }

    String getHeaderFileName() {
        return this.headerFileName;
    }

    String getMsgFileName() {
        return this.msgFileName;
    }

    String getSeqNumFileName() {
        return this.seqNumFileName;
    }

    @Override
    public void refresh() throws IOException {
        this.initialize(false);
    }

    @Override
    public void reset() throws IOException {
        this.initialize(true);
    }

    private class CachedHashMap
    implements Map<Long, long[]> {
        private final TreeMap<Long, long[]> cacheIndex = new TreeMap();
        private int currentSize = 0;
        private final int maxSize;

        public CachedHashMap(int _maxSize) {
            this.maxSize = _maxSize;
        }

        @Override
        public void clear() {
            this.cacheIndex.clear();
            this.currentSize = 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.cacheIndex.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.cacheIndex.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Long, long[]>> entrySet() {
            return this.cacheIndex.entrySet();
        }

        @Override
        public long[] get(Object key) {
            long[] v = this.cacheIndex.get(key);
            if (v != null) {
                return v;
            }
            return this.seekMessageIndex((Long)key);
        }

        @Override
        public boolean isEmpty() {
            return this.cacheIndex.isEmpty();
        }

        @Override
        public Set<Long> keySet() {
            return this.cacheIndex.keySet();
        }

        @Override
        public long[] put(Long key, long[] value) {
            this.cacheIndex.put(key, value);
            ++this.currentSize;
            if (this.currentSize > this.maxSize) {
                Iterator<Map.Entry<Long, long[]>> it = this.cacheIndex.entrySet().iterator();
                it.next();
                it.remove();
                --this.currentSize;
            }
            return value;
        }

        @Override
        public void putAll(Map<? extends Long, ? extends long[]> t) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public long[] remove(Object key) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public int size() {
            return this.cacheIndex.size();
        }

        @Override
        public Collection<long[]> values() {
            return this.cacheIndex.values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long[] seekMessageIndex(long index) {
            File headerFile = new File(CachedFileStore.this.headerFileName);
            if (headerFile.exists()) {
                FilterInputStream headerDataInputStream = null;
                try {
                    headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
                    while (headerDataInputStream.available() > 0) {
                        int sequenceNumber = ((DataInputStream)headerDataInputStream).readInt();
                        long offset = ((DataInputStream)headerDataInputStream).readLong();
                        int size = ((DataInputStream)headerDataInputStream).readInt();
                        if (index != (long)sequenceNumber) continue;
                        long[] lArray = new long[]{offset, size};
                        return lArray;
                    }
                }
                catch (IOException e) {
                    long[] lArray = null;
                    return lArray;
                }
                finally {
                    try {
                        if (headerDataInputStream != null) {
                            headerDataInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        CachedFileStore.this.log.error(CachedFileStore.NOSYNC_OPTION, (Throwable)e);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<long[]> seekMessageIndex(long startSequence, long endSequence) {
            TreeMap<Integer, long[]> indexPerSequenceNumber = new TreeMap<Integer, long[]>();
            File headerFile = new File(CachedFileStore.this.headerFileName);
            if (headerFile.exists()) {
                FilterInputStream headerDataInputStream = null;
                try {
                    headerDataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
                    while (headerDataInputStream.available() > 0) {
                        int sequenceNumber = ((DataInputStream)headerDataInputStream).readInt();
                        long offset = ((DataInputStream)headerDataInputStream).readLong();
                        int size = ((DataInputStream)headerDataInputStream).readInt();
                        if ((long)sequenceNumber < startSequence || (long)sequenceNumber > endSequence) continue;
                        indexPerSequenceNumber.put(sequenceNumber, new long[]{offset, size});
                    }
                }
                catch (IOException e) {
                    CachedFileStore.this.log.error(CachedFileStore.NOSYNC_OPTION, (Throwable)e);
                    List<long[]> list = null;
                    return list;
                }
                finally {
                    try {
                        if (headerDataInputStream != null) {
                            headerDataInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        CachedFileStore.this.log.error(CachedFileStore.NOSYNC_OPTION, (Throwable)e);
                    }
                }
            }
            return new ArrayList<long[]>(indexPerSequenceNumber.values());
        }

        public List<long[]> get(long startSequence, long endSequence) {
            return this.seekMessageIndex(startSequence, endSequence);
        }
    }
}

