/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ScalarTypes {
    private static Map<String, Class<?>> stringScalarToType = ImmutableMap.builder().put((Object)"integer", Integer.TYPE).put((Object)"boolean", Boolean.TYPE).put((Object)"date-time", Date.class).put((Object)"date", Date.class).put((Object)"number", BigDecimal.class).put((Object)"string", String.class).put((Object)"file", File.class).build();

    private static Class<?> scalarToJavaType(String name) {
        return stringScalarToType.get(name.toLowerCase());
    }

    public static boolean extendsScalarRamlType(TypeDeclaration typeDeclaration) {
        return ScalarTypes.scalarToJavaType(typeDeclaration.name()) != null;
    }

    public static TypeName classToTypeName(Class scalar) {
        if (scalar.isPrimitive()) {
            switch (scalar.getSimpleName()) {
                case "int": {
                    return TypeName.INT;
                }
                case "boolean": {
                    return TypeName.BOOLEAN;
                }
                case "double": {
                    return TypeName.DOUBLE;
                }
                case "float": {
                    return TypeName.FLOAT;
                }
                case "byte": {
                    return TypeName.BYTE;
                }
                case "char": {
                    return TypeName.CHAR;
                }
                case "short": {
                    return TypeName.SHORT;
                }
                case "long": {
                    return TypeName.LONG;
                }
                case "void": {
                    return TypeName.VOID;
                }
            }
            throw new GenerationException("can't handle type: " + scalar);
        }
        return ClassName.get((Class)scalar);
    }
}

