/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.resources;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.HTTPMethods;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.ResourceUtils;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGeneratorBase;
import org.raml.jaxrs.generator.builders.extensions.resources.ResourceContextImpl;
import org.raml.jaxrs.generator.builders.resources.ResourceGenerator;
import org.raml.jaxrs.generator.extension.resources.api.ResourceClassExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceContext;
import org.raml.jaxrs.generator.extension.resources.api.ResourceMethodExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResponseClassExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResponseMethodExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.ramltypes.GResponseType;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class ResourceBuilder
implements ResourceGenerator {
    private final CurrentBuild build;
    private final GResource topResource;
    private final String name;
    private final String uri;

    public ResourceBuilder(CurrentBuild build, GResource resource, String name, String uri) {
        this.build = build;
        this.topResource = resource;
        this.name = name;
        this.uri = uri;
    }

    @Override
    public void output(CodeContainer<TypeSpec> container) throws IOException {
        TypeSpec.Builder typeSpec = new DefaultResourceClassCreator().onResource((ResourceContext)new ResourceContextImpl(this.build), this.topResource, (TypeSpec.Builder)null);
        if (typeSpec != null) {
            container.into(typeSpec.build());
        }
    }

    private void recurse(TypeSpec.Builder typeSpec, GResource parentResource) {
        for (GResource resource : parentResource.resources()) {
            this.buildResource(typeSpec, resource);
            this.recurse(typeSpec, resource);
        }
    }

    private void buildResource(TypeSpec.Builder typeSpec, GResource currentResource) {
        ArrayListMultimap incomingBodies = ArrayListMultimap.create();
        ArrayListMultimap responses = ArrayListMultimap.create();
        ResourceUtils.fillInBodiesAndResponses(currentResource, (Multimap<GMethod, GRequest>)incomingBodies, (Multimap<GMethod, GResponse>)responses);
        Map<String, TypeSpec.Builder> responseSpecs = this.createResponseClass(typeSpec, (Multimap<GMethod, GRequest>)incomingBodies, (Multimap<GMethod, GResponse>)responses);
        for (GMethod gMethod : currentResource.methods()) {
            String methodName = Names.resourceMethodName(gMethod.resource(), gMethod);
            Set<String> mediaTypesForMethod = this.fetchAllMediaTypesForMethodResponses(gMethod);
            if (gMethod.body().size() == 0) {
                this.createMethodWithoutBody(typeSpec, gMethod, mediaTypesForMethod, (Multimap<String, String>)HashMultimap.create(), methodName, responseSpecs);
                continue;
            }
            Multimap<String, String> ramlTypeToMediaType = this.accumulateMediaTypesPerType((Multimap<GMethod, GRequest>)incomingBodies, gMethod);
            for (GRequest gRequest : gMethod.body()) {
                if (gRequest.type() == null) {
                    this.createMethodWithoutBody(typeSpec, gMethod, mediaTypesForMethod, ramlTypeToMediaType, methodName, responseSpecs);
                    continue;
                }
                if (!ramlTypeToMediaType.containsKey((Object)gRequest.type().name())) continue;
                this.createMethodWithBody(typeSpec, gMethod, ramlTypeToMediaType, methodName, gRequest, responseSpecs, mediaTypesForMethod);
                ramlTypeToMediaType.removeAll((Object)gRequest.type().name());
            }
        }
    }

    private Multimap<String, String> accumulateMediaTypesPerType(Multimap<GMethod, GRequest> incomingBodies, GMethod gMethod) {
        ArrayListMultimap ramlTypeToMediaType = ArrayListMultimap.create();
        for (GRequest request : incomingBodies.get((Object)gMethod)) {
            if (request == null) continue;
            if (request.type() == null) {
                ramlTypeToMediaType.put(null, (Object)request.mediaType());
                continue;
            }
            ramlTypeToMediaType.put((Object)request.type().name(), (Object)request.mediaType());
        }
        return ramlTypeToMediaType;
    }

    private void createMethodWithoutBody(TypeSpec.Builder typeSpec, GMethod gMethod, Set<String> mediaTypesForMethod, Multimap<String, String> ramlTypeToMediaType, String methodName, Map<String, TypeSpec.Builder> responseSpecs) {
        MethodSpec.Builder methodSpec = this.createMethodBuilder(gMethod, methodName, mediaTypesForMethod, responseSpecs);
        methodSpec = this.build.pluginsForResourceMethod(new Function<Collection<ResourceMethodExtension<GMethod>>, ResourceMethodExtension<GMethod>>(){

            @Nullable
            public ResourceMethodExtension<GMethod> apply(@Nullable Collection<ResourceMethodExtension<GMethod>> resourceMethodExtensions) {
                return new ResourceMethodExtension.Composite(resourceMethodExtensions);
            }
        }, gMethod).onMethod(new ResourceContextImpl(this.build), gMethod, null, methodSpec);
        this.handleMethodConsumer(methodSpec, ramlTypeToMediaType, null);
        if (methodSpec != null) {
            typeSpec.addMethod(methodSpec.build());
        }
    }

    private void createMethodWithBody(TypeSpec.Builder typeSpec, GMethod gMethod, Multimap<String, String> ramlTypeToMediaType, String methodName, GRequest gRequest, Map<String, TypeSpec.Builder> responseSpec, Set<String> mediaTypesForMethod) {
        MethodSpec.Builder methodSpec = this.createMethodBuilder(gMethod, methodName, mediaTypesForMethod, responseSpec);
        this.createParamteter(methodSpec, gRequest, gMethod);
        this.handleMethodConsumer(methodSpec, ramlTypeToMediaType, gRequest.type());
        methodSpec = this.build.pluginsForResourceMethod(new Function<Collection<ResourceMethodExtension<GMethod>>, ResourceMethodExtension<GMethod>>(){

            @Nullable
            public ResourceMethodExtension<GMethod> apply(@Nullable Collection<ResourceMethodExtension<GMethod>> resourceMethodExtensions) {
                return new ResourceMethodExtension.Composite(resourceMethodExtensions);
            }
        }, gMethod).onMethod(new ResourceContextImpl(this.build), gMethod, gRequest, methodSpec);
        if (methodSpec != null) {
            typeSpec.addMethod(methodSpec.build());
        }
    }

    private void createParamteter(MethodSpec.Builder methodSpec, GRequest gRequest, GMethod gMethod) {
        if ("application/x-www-form-urlencoded".equals(gRequest.mediaType())) {
            if (gRequest.type().implementation() instanceof ObjectTypeDeclaration) {
                ObjectTypeDeclaration object = (ObjectTypeDeclaration)gRequest.type().implementation();
                for (TypeDeclaration typeDeclaration : object.properties()) {
                    V10GType type = this.build.fetchType(Names.javaTypeName((Resource)gMethod.resource().implementation(), (Method)gMethod.implementation(), typeDeclaration), typeDeclaration);
                    methodSpec.addParameter(ParameterSpec.builder((TypeName)type.defaultJavaTypeName(this.build.getModelPackage()), (String)typeDeclaration.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(FormParam.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build()).build());
                }
            }
            return;
        }
        if (gRequest.type().name().equals("any") && "application/octet-stream".equals(gRequest.mediaType())) {
            ClassName typeName = ClassName.get(InputStream.class);
            methodSpec.addParameter(ParameterSpec.builder((TypeName)typeName, (String)"entity", (Modifier[])new Modifier[0]).build());
        } else {
            TypeName typeName = gRequest.type().defaultJavaTypeName(this.build.getModelPackage());
            methodSpec.addParameter(ParameterSpec.builder((TypeName)typeName, (String)"entity", (Modifier[])new Modifier[0]).build());
        }
    }

    private Set<String> fetchAllMediaTypesForMethodResponses(GMethod gMethod) {
        HashSet<String> mediaTypes = new HashSet<String>();
        for (GResponse gResponse : gMethod.responses()) {
            mediaTypes.addAll(Lists.transform(gResponse.body(), (Function)new Function<GResponseType, String>(){

                @Nullable
                public String apply(@Nullable GResponseType input) {
                    return input.mediaType();
                }
            }));
        }
        return mediaTypes;
    }

    private Map<String, TypeSpec.Builder> createResponseClass(TypeSpec.Builder typeSpec, Multimap<GMethod, GRequest> bodies, Multimap<GMethod, GResponse> responses) {
        HashMap<String, TypeSpec.Builder> map = new HashMap<String, TypeSpec.Builder>();
        HashSet allMethods = new HashSet();
        allMethods.addAll(bodies.keySet());
        allMethods.addAll(responses.keySet());
        for (GMethod gMethod : allMethods) {
            if (gMethod.responses().size() == 0) continue;
            String defaultName = Names.responseClassName(gMethod.resource(), gMethod);
            TypeSpec.Builder responseClass = TypeSpec.classBuilder((String)defaultName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ClassName.get((String)this.build.getSupportPackage(), (String)"ResponseDelegate", (String[])new String[0])).addMethod(MethodSpec.constructorBuilder().addParameter(Response.class, "response", new Modifier[0]).addParameter(Object.class, "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("super(response, entity);\n", new Object[0]).build()).addMethod(MethodSpec.constructorBuilder().addParameter(Response.class, "response", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("super(response);\n", new Object[0]).build());
            map.put(defaultName, null);
            TypeSpec currentClass = responseClass.build();
            for (GResponse gResponse : responses.get((Object)gMethod)) {
                if (gResponse == null) continue;
                TypeSpec internalClassForHeaders = null;
                if (!gResponse.headers().isEmpty()) {
                    internalClassForHeaders = this.buildHeadersForResponse(responseClass, gResponse.headers(), gResponse.code());
                }
                if (gResponse.body().size() == 0) {
                    String httpCode = gResponse.code();
                    MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("respond" + httpCode));
                    builder.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)currentClass.name));
                    if (internalClassForHeaders == null) {
                        builder.addStatement("Response.ResponseBuilder responseBuilder = Response.status(" + httpCode + ")", new Object[0]).addStatement("return new $N(responseBuilder.build())", new Object[]{currentClass});
                    } else {
                        builder.addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"", (String)internalClassForHeaders.name, (String[])new String[0]), (String)"headers", (Modifier[])new Modifier[0]).build()).addStatement("Response.ResponseBuilder responseBuilder = Response.status(" + httpCode + ")", new Object[0]).addStatement("responseBuilder = headers.toResponseBuilder(responseBuilder)", new Object[0]).addStatement("return new $N(responseBuilder.build())", new Object[]{currentClass});
                    }
                    builder = this.build.pluginsForResponseMethod(new Function<Collection<ResponseMethodExtension<GResponse>>, ResponseMethodExtension<GResponse>>(){

                        @Nullable
                        public ResponseMethodExtension<GResponse> apply(@Nullable Collection<ResponseMethodExtension<GResponse>> responseMethodExtensions) {
                            return new ResponseMethodExtension.Composite(responseMethodExtensions);
                        }
                    }, gResponse).onMethod(new ResourceContextImpl(this.build), gResponse, builder);
                    if (builder == null) continue;
                    responseClass.addMethod(builder.build());
                    continue;
                }
                for (GResponseType responseType : gResponse.body()) {
                    String httpCode = gResponse.code();
                    MethodSpec.Builder builder = MethodSpec.methodBuilder((String)Names.methodName("respond", httpCode, "With", responseType.mediaType())).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC});
                    builder.returns((TypeName)TypeVariableName.get((String)currentClass.name));
                    TypeName typeName = this.createResponseParameter(responseType, builder);
                    if (internalClassForHeaders != null) {
                        builder.addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"", (String)internalClassForHeaders.name, (String[])new String[0]), (String)"headers", (Modifier[])new Modifier[0]).build());
                    }
                    builder.addStatement("Response.ResponseBuilder responseBuilder = Response.status(" + httpCode + ").header(\"Content-Type\", \"" + responseType.mediaType() + "\")", new Object[0]);
                    if (responseType.type() == null) {
                        if (internalClassForHeaders == null) {
                            builder.addStatement("responseBuilder.entity(null)", new Object[0]).addStatement("return new $N(responseBuilder.build(), null)", new Object[]{currentClass});
                        } else {
                            builder.addStatement("responseBuilder.entity(null)", new Object[0]).addStatement("headers.toResponseBuilder(responseBuilder)", new Object[0]).addStatement("return new $N(responseBuilder.build(), null)", new Object[]{currentClass});
                        }
                    } else if (responseType.type().isArray()) {
                        if (internalClassForHeaders == null) {
                            builder.addStatement("$T<$T> wrappedEntity = new $T<$T>(entity){}", new Object[]{GenericEntity.class, typeName, GenericEntity.class, typeName}).addStatement("responseBuilder.entity(wrappedEntity)", new Object[0]).addStatement("return new $N(responseBuilder.build(), wrappedEntity)", new Object[]{currentClass});
                        } else {
                            builder.addStatement("$T<$T> wrappedEntity = new $T<$T>(entity){}", new Object[]{GenericEntity.class, typeName, GenericEntity.class, typeName}).addStatement("headers.toResponseBuilder(responseBuilder)", new Object[0]).addStatement("responseBuilder.entity(wrappedEntity)", new Object[0]).addStatement("return new $N(responseBuilder.build(), wrappedEntity)", new Object[]{currentClass});
                        }
                    } else if (internalClassForHeaders == null) {
                        builder.addStatement("responseBuilder.entity(entity)", new Object[0]).addStatement("return new $N(responseBuilder.build(), entity)", new Object[]{currentClass});
                    } else {
                        builder.addStatement("responseBuilder.entity(entity)", new Object[0]).addStatement("headers.toResponseBuilder(responseBuilder)", new Object[0]).addStatement("return new $N(responseBuilder.build(), entity)", new Object[]{currentClass});
                    }
                    builder = this.build.pluginsForResponseMethod(new Function<Collection<ResponseMethodExtension<GResponse>>, ResponseMethodExtension<GResponse>>(){

                        @Nullable
                        public ResponseMethodExtension<GResponse> apply(@Nullable Collection<ResponseMethodExtension<GResponse>> responseMethodExtensions) {
                            return new ResponseMethodExtension.Composite(responseMethodExtensions);
                        }
                    }, gResponse).onMethod(new ResourceContextImpl(this.build), gResponse, builder);
                    if (builder == null) continue;
                    responseClass.addMethod(builder.build());
                }
            }
            responseClass = this.build.pluginsForResponseClass(new Function<Collection<ResponseClassExtension<GMethod>>, ResponseClassExtension<GMethod>>(){

                @Nullable
                public ResponseClassExtension<GMethod> apply(@Nullable Collection<ResponseClassExtension<GMethod>> responseClassExtensions) {
                    return new ResponseClassExtension.Composite(responseClassExtensions);
                }
            }, gMethod).onResponseClass(new ResourceContextImpl(this.build), gMethod, responseClass);
            if (responseClass == null) {
                map.put(defaultName, null);
                continue;
            }
            map.put(defaultName, responseClass);
            typeSpec.addType(responseClass.build());
        }
        return map;
    }

    private TypeName createResponseParameter(GResponseType responseType, MethodSpec.Builder builder) {
        if ("application/octet-stream".equals(responseType.mediaType()) && "any".equals(responseType.type().name())) {
            ClassName typeName = ClassName.get(StreamingOutput.class);
            builder.addParameter(ParameterSpec.builder((TypeName)typeName, (String)"entity", (Modifier[])new Modifier[0]).build());
            return typeName;
        }
        if (responseType.type() != null) {
            TypeName typeName = responseType.type().defaultJavaTypeName(this.build.getModelPackage());
            if (typeName == null) {
                throw new GenerationException(responseType.mediaType() + "," + responseType.type().name() + " was not seen before");
            }
            builder.addParameter(ParameterSpec.builder((TypeName)typeName, (String)"entity", (Modifier[])new Modifier[0]).build());
            return typeName;
        }
        return null;
    }

    private TypeSpec buildHeadersForResponse(TypeSpec.Builder responseClass, List<GParameter> headers, String code) {
        responseClass.addMethod(MethodSpec.methodBuilder((String)Names.methodName("headersFor" + code)).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)("HeadersFor" + code), (String[])new String[0])).addStatement("return new HeadersFor" + code + "()", new Object[0]).build());
        TypeSpec.Builder headerForCode = TypeSpec.classBuilder((String)("HeadersFor" + code)).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)"", (String)"HeaderBuilderBase", (String[])new String[0])).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (GParameter header : headers) {
            MethodSpec spec = MethodSpec.methodBuilder((String)Names.methodName("with", header.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)("HeadersFor" + code), (String[])new String[0])).addParameter(ParameterSpec.builder((TypeName)header.type().defaultJavaTypeName(this.build.getModelPackage()), (String)"p", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("headerMap.put($S, String.valueOf(p));", new Object[]{header.name()}).addStatement("return this", new Object[0]).build();
            headerForCode.addMethod(spec);
        }
        TypeSpec build = headerForCode.build();
        responseClass.addType(build);
        return build;
    }

    private MethodSpec.Builder createMethodBuilder(GMethod gMethod, String methodName, Set<String> mediaTypesForMethod, Map<String, TypeSpec.Builder> responseSpec) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
        for (GParameter parameter : ResourceUtils.accumulateUriParameters(gMethod.resource())) {
            methodSpec.addParameter(ParameterSpec.builder((TypeName)parameter.type().defaultJavaTypeName(this.build.getModelPackage()), (String)Names.methodName(parameter.name()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(PathParam.class).addMember("value", "$S", new Object[]{parameter.name()}).build()).build());
        }
        for (GParameter gParameter : gMethod.queryParameters()) {
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)gParameter.type().defaultJavaTypeName(this.build.getModelPackage()), (String)Names.methodName(gParameter.name()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{gParameter.name()}).build());
            if (gParameter.defaultValue() != null) {
                parameterSpec.addAnnotation(AnnotationSpec.builder(DefaultValue.class).addMember("value", "$S", new Object[]{gParameter.defaultValue()}).build());
            }
            methodSpec.addParameter(parameterSpec.build());
        }
        for (GParameter gParameter : gMethod.headers()) {
            methodSpec.addParameter(ParameterSpec.builder((TypeName)gParameter.type().defaultJavaTypeName(this.build.getModelPackage()), (String)Names.methodName(gParameter.name()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(HeaderParam.class).addMember("value", "$S", new Object[]{gParameter.name()}).build()).build());
        }
        this.buildNewWebMethod(gMethod, methodSpec);
        if (gMethod.resource().parentResource() != null) {
            methodSpec.addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{gMethod.resource().resourcePath().substring(this.findTopResource(gMethod.resource().parentResource()).resourcePath().length())}).build());
        }
        if (gMethod.responses().size() != 0) {
            TypeSpec.Builder responseSpecForMethod = responseSpec.get(Names.responseClassName(gMethod.resource(), gMethod));
            if (responseSpecForMethod == null) {
                methodSpec.returns((TypeName)ClassName.get(Response.class));
            } else {
                methodSpec.returns((TypeName)ClassName.get((String)"", (String)responseSpecForMethod.build().name, (String[])new String[0]));
            }
        } else {
            methodSpec.returns(ClassName.VOID);
        }
        if (mediaTypesForMethod.size() > 0) {
            AnnotationSpec.Builder ann = this.buildAnnotation(mediaTypesForMethod, Produces.class);
            methodSpec.addAnnotation(ann.build());
        }
        return methodSpec;
    }

    private GResource findTopResource(GResource gResource) {
        if (gResource.parentResource() == null) {
            return gResource;
        }
        return this.findTopResource(gResource.parentResource());
    }

    private void buildNewWebMethod(GMethod gMethod, MethodSpec.Builder methodSpec) {
        Class<? extends Annotation> type = HTTPMethods.methodNameToAnnotation(gMethod.method());
        if (type == null) {
            String name = gMethod.method().toUpperCase();
            ClassName className = ClassName.get((String)this.build.getSupportPackage(), (String)name, (String[])new String[0]);
            final TypeSpec.Builder builder = TypeSpec.annotationBuilder((ClassName)className);
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Target.class).addMember("value", "{$T.$L}", new Object[]{ElementType.class, "METHOD"}).build()).addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, "RUNTIME"}).build()).addAnnotation(AnnotationSpec.builder(HttpMethod.class).addMember("value", "$S", new Object[]{name}).build());
            this.build.newSupportGenerator(new JavaPoetTypeGeneratorBase((TypeName)className){

                @Override
                public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
                    rootDirectory.into(builder);
                }
            });
            methodSpec.addAnnotation(AnnotationSpec.builder((ClassName)className).build());
        } else {
            methodSpec.addAnnotation(AnnotationSpec.builder(type).build());
        }
    }

    private void handleMethodConsumer(MethodSpec.Builder methodSpec, Multimap<String, String> ramlTypeToMediaType, GType typeDeclaration) {
        Collection mediaTypes = ramlTypeToMediaType.get((Object)(typeDeclaration == null ? null : typeDeclaration.name()));
        if (mediaTypes.size() > 0) {
            AnnotationSpec.Builder ann = this.buildAnnotation(mediaTypes, Consumes.class);
            methodSpec.addAnnotation(ann.build());
        }
    }

    private AnnotationSpec.Builder buildAnnotation(Collection<String> mediaTypes, Class<? extends Annotation> type) {
        AnnotationSpec.Builder ann = AnnotationSpec.builder(type);
        for (String mediaType : mediaTypes) {
            ann.addMember("value", "$S", new Object[]{mediaType});
        }
        return ann;
    }

    private class DefaultResourceClassCreator
    implements ResourceClassExtension<GResource> {
        private DefaultResourceClassCreator() {
        }

        @Override
        public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder nullSpec) {
            TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((String)Names.typeName(ResourceBuilder.this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{ResourceBuilder.this.uri}).build());
            ResourceBuilder.this.buildResource(typeSpec, ResourceBuilder.this.topResource);
            ResourceBuilder.this.recurse(typeSpec, ResourceBuilder.this.topResource);
            typeSpec = ResourceBuilder.this.build.pluginsForResourceClass(new Function<Collection<ResourceClassExtension<GResource>>, ResourceClassExtension<GResource>>(){

                @Nullable
                public ResourceClassExtension<GResource> apply(@Nullable Collection<ResourceClassExtension<GResource>> resourceClassExtensions) {
                    return new ResourceClassExtension.Composite(resourceClassExtensions);
                }
            }, ResourceBuilder.this.topResource).onResource(new ResourceContextImpl(ResourceBuilder.this.build), ResourceBuilder.this.topResource, typeSpec);
            return typeSpec;
        }
    }
}

