/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.extension.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.raml.jaxrs.generator.extension.resources.api.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.api.ResourceContext;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;

public class ListEntityValueResourceExtension
implements GlobalResourceExtension {
    private final List<String> arguments;

    public ListEntityValueResourceExtension(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public TypeSpec.Builder onResource(ResourceContext context, GResource resource, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GMethod method, GRequest gRequest, MethodSpec.Builder methodSpec) {
        MethodSpec old = methodSpec.build();
        MethodSpec.Builder newMethod = MethodSpec.methodBuilder((String)old.name).returns(old.returnType);
        this.addParameters(old, newMethod);
        for (AnnotationSpec annotation : old.annotations) {
            newMethod.addAnnotation(annotation);
        }
        newMethod.addJavadoc("$L", new Object[]{old.javadoc});
        newMethod.addModifiers((Iterable)old.modifiers);
        if (old.javadoc != null) {
            newMethod.addJavadoc("$S", new Object[]{old.javadoc});
        }
        for (TypeName exception : old.exceptions) {
            newMethod.addException(exception);
        }
        return newMethod;
    }

    private void addParameters(MethodSpec old, MethodSpec.Builder newMethod) {
        for (ParameterSpec parameter : old.parameters) {
            if (FluentIterable.from((Iterable)parameter.annotations).filter((Predicate)new Predicate<AnnotationSpec>(){

                public boolean apply(@Nullable AnnotationSpec annotationSpec) {
                    return annotationSpec.type.equals((Object)ClassName.get(PathParam.class)) || annotationSpec.type.equals((Object)ClassName.get(QueryParam.class));
                }
            }).size() <= 0) continue;
            newMethod.addParameter(parameter);
        }
        for (ParameterSpec parameter : old.parameters) {
            if (FluentIterable.from((Iterable)parameter.annotations).filter((Predicate)new Predicate<AnnotationSpec>(){

                public boolean apply(@Nullable AnnotationSpec annotationSpec) {
                    return annotationSpec.type.equals((Object)ClassName.get(PathParam.class)) || annotationSpec.type.equals((Object)ClassName.get(QueryParam.class));
                }
            }).size() != 0) continue;
            newMethod.addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.bestGuess((String)this.arguments.get(0))}), (String)"entity", (Modifier[])new Modifier[0]).build());
        }
    }

    @Override
    public TypeSpec.Builder onResponseClass(ResourceContext context, GMethod method, TypeSpec.Builder typeSpec) {
        return typeSpec;
    }

    @Override
    public MethodSpec.Builder onMethod(ResourceContext context, GResponse responseMethod, MethodSpec.Builder methodSpec) {
        MethodSpec old = methodSpec.build();
        MethodSpec.Builder newMethod = MethodSpec.methodBuilder((String)old.name).returns(old.returnType);
        this.addParameters(old, newMethod);
        for (AnnotationSpec annotation : old.annotations) {
            newMethod.addAnnotation(annotation);
        }
        newMethod.addJavadoc("$L", new Object[]{old.javadoc});
        newMethod.addModifiers((Iterable)old.modifiers);
        if (old.javadoc != null) {
            newMethod.addJavadoc("$S", new Object[]{old.javadoc});
        }
        for (TypeName exception : old.exceptions) {
            newMethod.addException(exception);
        }
        newMethod.addCode(old.code);
        return newMethod;
    }
}

