/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.TypeUtils;
import org.raml.jaxrs.generator.v10.V10GRequest;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponse;
import org.raml.jaxrs.generator.v10.V10PGParameter;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class V10GMethod
implements GMethod {
    private V10GResource v10GResource;
    private final Method method;
    private final List<GParameter> queryParameters;
    private final List<GParameter> headers;
    private final List<GResponse> responses;
    private List<GRequest> requests;

    public V10GMethod(final CurrentBuild currentBuild, final V10GResource v10GResource, final Method method) {
        this.v10GResource = v10GResource;
        this.method = method;
        this.requests = Lists.transform((List)this.method.body(), (Function)new Function<TypeDeclaration, GRequest>(){

            @Nullable
            public GRequest apply(@Nullable TypeDeclaration input) {
                return new V10GRequest(input, currentBuild.fetchType(v10GResource.implementation(), method, input));
            }
        });
        this.responses = Lists.transform((List)this.method.responses(), (Function)new Function<Response, GResponse>(){

            @Nullable
            public GResponse apply(@Nullable Response input) {
                return new V10GResponse(currentBuild, v10GResource, method, input);
            }
        });
        this.queryParameters = Lists.transform((List)this.method.queryParameters(), (Function)new Function<TypeDeclaration, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable TypeDeclaration input) {
                if (TypeUtils.shouldCreateNewClass(input, input.parentTypes().toArray(new TypeDeclaration[0]))) {
                    return new V10PGParameter(input, currentBuild.fetchType(v10GResource.implementation(), method, input));
                }
                return new V10PGParameter(input, currentBuild.fetchType(input.type(), input));
            }
        });
        this.headers = Lists.transform((List)this.method.headers(), (Function)new Function<TypeDeclaration, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable TypeDeclaration input) {
                if (TypeUtils.shouldCreateNewClass(input, input.parentTypes().toArray(new TypeDeclaration[0]))) {
                    return new V10PGParameter(input, currentBuild.fetchType(v10GResource.implementation(), method, input));
                }
                return new V10PGParameter(input, currentBuild.fetchType(input.type(), input));
            }
        });
    }

    public Method implementation() {
        return this.method;
    }

    @Override
    public List<GRequest> body() {
        return this.requests;
    }

    @Override
    public GResource resource() {
        return this.v10GResource;
    }

    @Override
    public String method() {
        return this.method.method();
    }

    @Override
    public List<GParameter> queryParameters() {
        return this.queryParameters;
    }

    @Override
    public List<GParameter> headers() {
        return this.headers;
    }

    @Override
    public List<GResponse> responses() {
        return this.responses;
    }

    @Override
    public String getDescription() {
        return this.method.description() != null ? this.method.description().value() : null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof V10GMethod)) {
            return false;
        }
        V10GMethod method = (V10GMethod)obj;
        return method.v10GResource.resourcePath().equals(this.v10GResource.resourcePath()) && method.method().equals(this.method());
    }

    public int hashCode() {
        return this.method().hashCode() + this.v10GResource.resourcePath().hashCode();
    }

    public String toString() {
        return "V10GMethod{resource=" + this.v10GResource.resourcePath() + ", method=" + this.method.method() + '}';
    }
}

