/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.ramltopojo.CreationResult;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.GenerationContext;
import org.raml.ramltopojo.TypeDeclarationType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class ObjectPluginContextImpl
implements ObjectPluginContext {
    private final GenerationContext generationContext;
    private final CreationResult result;

    public ObjectPluginContextImpl(GenerationContext generationContext, CreationResult result) {
        this.generationContext = generationContext;
        this.result = result;
    }

    @Override
    public Set<CreationResult> childClasses(String ramlTypeName) {
        return FluentIterable.from(this.generationContext.childClasses(ramlTypeName)).transform((Function)new Function<String, CreationResult>(){

            @Nullable
            public CreationResult apply(@Nullable String input) {
                return ObjectPluginContextImpl.this.generationContext.findCreatedType(input, null);
            }
        }).toSet();
    }

    @Override
    public CreationResult creationResult() {
        return this.result;
    }

    @Override
    public CreationResult dependentType(TypeDeclaration items) {
        return this.generationContext.findCreatedType(items.name(), items);
    }

    @Override
    public TypeName forProperty(TypeDeclaration typeDeclaration) {
        return TypeDeclarationType.calculateTypeName("", typeDeclaration, this.generationContext, EventType.INTERFACE);
    }

    @Override
    public TypeName createSupportClass(TypeSpec.Builder newSupportType) {
        return this.generationContext.createSupportClass(newSupportType);
    }
}

