/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jackson2;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.lang.model.element.Modifier;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JacksonScalarTypeSerialization
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public FieldSpec.Builder fieldBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration typeDeclaration, FieldSpec.Builder builder, EventType eventType) {
        if (typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd'T'HH:mm:ss"}).build());
        }
        if (typeDeclaration instanceof TimeOnlyTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"HH:mm:ss"}).build());
        }
        if (typeDeclaration instanceof DateTypeDeclaration) {
            builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd"}).build());
        }
        if (typeDeclaration instanceof DateTimeTypeDeclaration) {
            String format = ((DateTimeTypeDeclaration)typeDeclaration).format();
            if (format != null && "rfc2616".equals(format)) {
                builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"EEE, dd MMM yyyy HH:mm:ss z"}).build());
            } else {
                TypeName name = objectPluginContext.createSupportClass(this.createSerialisationForDateTime(objectPluginContext));
                builder.addAnnotation(AnnotationSpec.builder(JsonFormat.class).addMember("shape", "$T.STRING", new Object[]{JsonFormat.Shape.class}).addMember("pattern", "$S", new Object[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).build()).addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("using", "$T.class", new Object[]{name}).build());
            }
        }
        return builder;
    }

    private TypeSpec.Builder createSerialisationForDateTime(ObjectPluginContext objectPluginContext) {
        ClassName returnType = ClassName.get(Date.class);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"TimestampDeserializer").addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(StdDeserializer.class), (TypeName[])new TypeName[]{returnType})).addField(FieldSpec.builder(StdDateFormat.class, (String)"DATE_PARSER", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{StdDateFormat.class}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super($T.class);", new Object[]{returnType}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder deserialize = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(JsonParser.class), (String)"jsonParser", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get(DeserializationContext.class), (String)"jsonContext", (Modifier[])new Modifier[0]).build()).addException(IOException.class).addException(JsonProcessingException.class).returns((TypeName)returnType).addCode(CodeBlock.builder().beginControlFlow("try", new Object[0]).add(CodeBlock.builder().addStatement("$T mapper  = new $T()", new Object[]{ObjectMapper.class, ObjectMapper.class}).addStatement("$T dateString = mapper.readValue(jsonParser, String.class)", new Object[]{String.class}).addStatement("Date date = DATE_PARSER.parse(dateString)", new Object[]{SimpleDateFormat.class}).addStatement("return date", new Object[0]).build()).add("} catch ($T e) {", new Object[]{ParseException.class}).addStatement("throw new $T(e)", new Object[]{IOException.class}).endControlFlow().build());
        builder.addMethod(deserialize.build());
        objectPluginContext.createSupportClass(builder);
        return builder;
    }
}

