/*
 * Decompiled with CFR 0.152.
 */
package org.raml.ramltopojo.extensions.jaxb;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.raml.ramltopojo.EventType;
import org.raml.ramltopojo.extensions.ObjectPluginContext;
import org.raml.ramltopojo.extensions.ObjectTypeHandlerPlugin;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class JaxbObjectExtension
extends ObjectTypeHandlerPlugin.Helper {
    @Override
    public TypeSpec.Builder classCreated(ObjectPluginContext objectPluginContext, ObjectTypeDeclaration type, TypeSpec.Builder builder, EventType eventType) {
        String name;
        String namespace = type.xml() != null && type.xml().namespace() != null ? type.xml().namespace() : "##default";
        String string = name = type.xml() != null && type.xml().name() != null ? type.xml().name() : type.name();
        if (eventType == EventType.IMPLEMENTATION) {
            builder.addAnnotation(AnnotationSpec.builder(XmlAccessorType.class).addMember("value", "$T.$L", new Object[]{XmlAccessType.class, "FIELD"}).build());
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(XmlRootElement.class).addMember("namespace", "$S", new Object[]{namespace}).addMember("name", "$S", new Object[]{name});
            builder.addAnnotation(annotation.build());
        } else {
            builder.addAnnotation(AnnotationSpec.builder(XmlRootElement.class).addMember("namespace", "$S", new Object[]{namespace}).addMember("name", "$S", new Object[]{name}).build());
        }
        return builder;
    }

    @Override
    public FieldSpec.Builder fieldBuilt(ObjectPluginContext objectPluginContext, TypeDeclaration property, FieldSpec.Builder fieldSpec, EventType eventType) {
        String name;
        String namespace = property.xml() != null && property.xml().namespace() != null ? property.xml().namespace() : "##default";
        String string = name = property.xml() != null && property.xml().name() != null ? property.xml().name() : property.name();
        if (eventType == EventType.IMPLEMENTATION) {
            if (property.xml() != null && property.xml().wrapped() != null && property.xml().wrapped().booleanValue() && this.isArray(property)) {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElementWrapper.class).addMember("name", "$S", new Object[]{name}).build());
                ClassName elementTypeName = objectPluginContext.dependentType(((ArrayTypeDeclaration)property).items()).getJavaName(EventType.IMPLEMENTATION);
                if (property.xml().attribute() != null && property.xml().attribute().booleanValue()) {
                    fieldSpec.addAnnotation(AnnotationSpec.builder(XmlAttribute.class).addMember("name", "$S", new Object[]{elementTypeName}).addMember("namespace", "$S", new Object[]{namespace}).build());
                } else {
                    fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElement.class).addMember("name", "$S", new Object[]{elementTypeName}).addMember("namespace", "$S", new Object[]{namespace}).build());
                }
            } else if (property.xml() != null && property.xml().attribute().booleanValue()) {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlAttribute.class).addMember("name", "$S", new Object[]{name}).addMember("namespace", "$S", new Object[]{namespace}).build());
            } else {
                fieldSpec.addAnnotation(AnnotationSpec.builder(XmlElement.class).addMember("name", "$S", new Object[]{name}).addMember("namespace", "$S", new Object[]{namespace}).build());
            }
        }
        return fieldSpec;
    }

    private boolean isArray(TypeDeclaration property) {
        return property instanceof ArrayTypeDeclaration;
    }
}

