/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.HierarchyVisitor;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VisitorStrategy<V extends Visitor> {
    public void accept(TypeInfo var1, V var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hierarchy<V extends HierarchyVisitor>
    implements VisitorStrategy<V> {
        @Override
        public void accept(TypeInfo type, V visitor) {
            this._accept(type, visitor);
        }

        private boolean _accept(TypeInfo type, V visitor) {
            if (type instanceof ClassTypeInfo) {
                ClassTypeInfo classType = (ClassTypeInfo)type;
                if (visitor.enter(classType)) {
                    TypeInfo superType = classType.getSuperType();
                    if (superType != null && !this._accept(superType, visitor)) {
                        return false;
                    }
                    for (TypeInfo implementedInterface : classType.getInterfaces()) {
                        if (this._accept(implementedInterface, visitor)) continue;
                        return false;
                    }
                    visitor.leave(classType);
                }
                return true;
            }
            if (type instanceof ParameterizedTypeInfo) {
                return this._accept(((ParameterizedTypeInfo)type).getRawType(), visitor);
            }
            throw new AssertionError();
        }
    }
}

