/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.introspection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodContainer
implements Iterable<MethodInfo> {
    private final Map<MethodSignature, MethodInfo> map = new HashMap<MethodSignature, MethodInfo>();

    MethodContainer() {
    }

    public void addAll(Iterable<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            this.add(method);
        }
    }

    public boolean add(MethodInfo method) {
        MethodSignature key = method.getSignature();
        MethodInfo existing = this.map.get(key);
        if (existing != null) {
            if (method.getReturnType().isCovariantWith(existing.getReturnType()) && existing.getOwner().isAssignableFrom(method.getOwner())) {
                this.map.put(key, method);
                return true;
            }
        } else {
            this.map.put(key, method);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MethodInfo> iterator() {
        return this.map.values().iterator();
    }
}

