/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.api;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public interface TypeInfo {

  /**
   * Returns true if the type is reified.
   *
   * @return the reifiability
   */
  boolean isReified();

  /**
   * Returns the name of the erased type corresponding of this type.
   *
   * @return the name of the erased type
   */
  String getName();

  /**
   * Unwraps the underlying type object and returns it
   *
   * @return the wrapped type object
   */
  Object unwrap();

  /**
   * Visit the type info.
   *
   * @param strategy the strategy
   * @param visitor the visitor
   * @param <V> the visitor generic type
   * @param <S> the strategy generic type
   */
  <V extends Visitor<V, S>, S extends VisitorStrategy<V, S>> void accept(S strategy, V visitor);

  /**
   * Returns true if the current type is a sub type of the argument.
   *
   * @param typeInfo the type to test
   * @return true if this type is a subtype of the argument
   */
  boolean isSubType(TypeInfo typeInfo);

}
