/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.apt;

import org.reflext.api.AccessScope;
import org.reflext.spi.model.FieldModel;

import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaxLangFieldModel implements FieldModel<Object, VariableElement> {

  @Override
  public Iterable<VariableElement> getDeclaredFields(Object classType) {
    if (classType instanceof TypeElement) {
      TypeElement typeElt = (TypeElement)classType;
      return ElementFilter.fieldsIn(typeElt.getEnclosedElements());
    } else {
      return getDeclaredFields(((DeclaredType)classType).asElement());
    }
  }

  @Override
  public String getName(VariableElement variableElement) {
    return variableElement.getSimpleName().toString();
  }

  @Override
  public AccessScope getAccess(VariableElement variableElement) {
    return JavaxLangReflectionModel.getAccess(variableElement);
  }

  @Override
  public Object getType(VariableElement variableElement) {
    return variableElement.asType();
  }

  @Override
  public boolean isStatic(VariableElement variableElement) {
    return JavaxLangReflectionModel.isStatic(variableElement);
  }

  @Override
  public boolean isFinal(VariableElement variableElement) {
    return JavaxLangReflectionModel.isFinal(variableElement);
  }

  @Override
  public Object getOwner(VariableElement variableElement) {
    return variableElement.getEnclosingElement();
  }
}
