/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.apt;

import javax.lang.model.element.*;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaxLangMethodAnnotationModel extends JavaxLangAnnotationModel<ExecutableElement> {

  public <A extends Annotation> A resolveDeclaredAnnotation(ExecutableElement method, Class<A> annotationClass) {
    return method.getAnnotation(annotationClass);
  }

  @Override
  public Collection<AnnotationMirror> getDeclaredAnnotation(ExecutableElement method) {
    List<? extends AnnotationMirror> list = method.getAnnotationMirrors();
    ArrayList<AnnotationMirror> tmp = new ArrayList<AnnotationMirror>(list.size());
    for (AnnotationMirror am : list) {
      tmp.add(am);
    }
    return tmp;
  }
}