/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.apt;

import org.reflext.api.AccessScope;
import org.reflext.spi.model.AnnotationModel;
import org.reflext.spi.model.FieldModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.ReflectionModel;
import org.reflext.spi.model.TypeModel;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import java.util.Set;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaxLangReflectionModel implements ReflectionModel<Object, ExecutableElement, AnnotationMirror, ExecutableElement, VariableElement> {

  public static JavaxLangReflectionModel getInstance() {
    return instance;
  }

  /** . */
  private static final JavaxLangReflectionModel instance = new JavaxLangReflectionModel();

  /** . */
  private final JavaxLangTypeModel typeModel = new JavaxLangTypeModel();

  /** . */
  private final JavaxLangFieldModel fieldModel = new JavaxLangFieldModel();

  /** . */
  private final JavaxLangMethodModel methodModel = new JavaxLangMethodModel();

  /** . */
  private final JavaxLangTypeAnnotationModel typeAnnotationModel = new JavaxLangTypeAnnotationModel();

  /** . */
  private final JavaxLangMethodAnnotationModel methodAnnotationModel = new JavaxLangMethodAnnotationModel();

  /** . */
  private final JavaxLangFieldAnnotationModel fieldAnnotationModel = new JavaxLangFieldAnnotationModel();

  @Override
  public TypeModel<Object> getTypeModel() {
    return typeModel;
  }

  @Override
  public FieldModel<Object, VariableElement> getFieldModel() {
    return fieldModel;
  }

  @Override
  public MethodModel<Object, ExecutableElement> getMethodModel() {
    return methodModel;
  }

  @Override
  public AnnotationModel<Object, Object, AnnotationMirror, ExecutableElement> getTypeAnnotationModel() {
    return typeAnnotationModel;
  }

  @Override
  public AnnotationModel<Object, ExecutableElement, AnnotationMirror, ExecutableElement> getMethodAnnotationModel() {
    return methodAnnotationModel;
  }

  @Override
  public AnnotationModel<Object, VariableElement, AnnotationMirror, ExecutableElement> getFieldAnnotationModel() {
    return fieldAnnotationModel;
  }

  static AccessScope getAccess(Element executableElement) {
    Set<Modifier> modifiers = executableElement.getModifiers();
    if (modifiers.contains(Modifier.PUBLIC)) {
      return AccessScope.PUBLIC;
    } else if (modifiers.contains(Modifier.PRIVATE)) {
      return AccessScope.PRIVATE;
    } else if (modifiers.contains(Modifier.PROTECTED)) {
      return AccessScope.PROTECTED;
    } else {
      return AccessScope.PACKAGE_PROTECTED;
    }
  }

  static boolean isAbstract(Element executableElement) {
    return executableElement.getModifiers().contains(Modifier.ABSTRACT);
  }

  static boolean isStatic(Element executableElement) {
    return executableElement.getModifiers().contains(Modifier.STATIC);
  }

  static boolean isNative(Element executableElement) {
    return executableElement.getModifiers().contains(Modifier.NATIVE);
  }

  static boolean isFinal(Element executableElement) {
    return executableElement.getModifiers().contains(Modifier.FINAL);
  }
}
