/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.List;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.Visitor;
import org.reflext.api.WildcardTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static TypeInfo resolve(ClassTypeInfo context, TypeInfo type) {
        if (type instanceof ClassTypeInfo) {
            return Utils.resolve(context, (ClassTypeInfo)type);
        }
        if (type instanceof ParameterizedTypeInfo) {
            return Utils.resolve(context, (ParameterizedTypeInfo)type);
        }
        if (type instanceof TypeVariableInfo) {
            return Utils.resolve(context, (TypeVariableInfo)type);
        }
        if (type instanceof ArrayTypeInfo) {
            return Utils.resolve(context, (ArrayTypeInfo)type);
        }
        if (type instanceof WildcardTypeInfo) {
            return Utils.resolve(context, (WildcardTypeInfo)type);
        }
        throw new UnsupportedOperationException("Cannot resolve type " + type + " with class " + type.getClass().getName());
    }

    static TypeInfo resolve(ClassTypeInfo context, WildcardTypeInfo wildcardType) {
        final ArrayList<TypeInfo> resolvedUpperBounds = new ArrayList<TypeInfo>();
        for (TypeInfo upperBound : wildcardType.getUpperBounds()) {
            resolvedUpperBounds.add(Utils.resolve(context, upperBound));
        }
        final ArrayList<TypeInfo> resolvedLowerBounds = new ArrayList<TypeInfo>();
        for (TypeInfo lowerBound : wildcardType.getLowerBounds()) {
            resolvedLowerBounds.add(Utils.resolve(context, lowerBound));
        }
        return new WildcardTypeInfo(){

            public List<TypeInfo> getUpperBounds() {
                return resolvedUpperBounds;
            }

            public List<TypeInfo> getLowerBounds() {
                return resolvedLowerBounds;
            }

            public int hashCode() {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object obj) {
                throw new UnsupportedOperationException();
            }

            public Object getType() {
                throw new UnsupportedOperationException();
            }

            public void accept(Visitor visitor) {
                throw new UnsupportedOperationException();
            }

            public boolean isSubType(TypeInfo ti) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static TypeInfo resolve(ClassTypeInfo context, ArrayTypeInfo genericArrayType) {
        TypeInfo componentType = genericArrayType.getComponentType();
        final TypeInfo resolvedComponentType = Utils.resolve(context, componentType);
        if (resolvedComponentType.equals(componentType)) {
            return genericArrayType;
        }
        return new ArrayTypeInfo(){

            public TypeInfo getComponentType() {
                return resolvedComponentType;
            }

            public Object getType() {
                throw new UnsupportedOperationException();
            }

            public void accept(Visitor visitor) {
                throw new UnsupportedOperationException();
            }

            public boolean isSubType(TypeInfo ti) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <T, M> TypeInfo resolve(ClassTypeInfo context, ClassTypeInfo classType) {
        return classType;
    }

    static <T, M> TypeInfo resolve(ClassTypeInfo context, final ParameterizedTypeInfo parameterizedType) {
        TypeInfo rawType = parameterizedType.getRawType();
        if (rawType instanceof ClassTypeInfo) {
            List typeArguments = parameterizedType.getTypeArguments();
            final ArrayList<TypeInfo> resolvedTypeArguments = new ArrayList<TypeInfo>();
            for (TypeInfo typeArgument : typeArguments) {
                TypeInfo resolvedTypeArgument = Utils.resolve(context, typeArgument);
                resolvedTypeArguments.add(resolvedTypeArgument);
            }
            return new ParameterizedTypeInfo(){

                public TypeInfo getRawType() {
                    return parameterizedType.getRawType();
                }

                public List<TypeInfo> getTypeArguments() {
                    return resolvedTypeArguments;
                }

                public TypeInfo getOwnerType() {
                    return parameterizedType.getOwnerType();
                }

                public String toString() {
                    return "ParameterizedType[rawType" + this.getRawType() + ",typeArguments=" + this.getTypeArguments() + "]";
                }

                public int hashCode() {
                    throw new UnsupportedOperationException();
                }

                public boolean equals(Object obj) {
                    throw new UnsupportedOperationException();
                }

                public Object getType() {
                    throw new UnsupportedOperationException();
                }

                public void accept(Visitor visitor) {
                    throw new UnsupportedOperationException();
                }

                public boolean isSubType(TypeInfo ti) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        throw new UnsupportedOperationException();
    }

    static <T, M> TypeInfo resolve(ClassTypeInfo context, TypeVariableInfo type) {
        return Utils.resolve((TypeInfo)context, type);
    }

    static <T, M> TypeInfo resolve(TypeInfo context, TypeVariableInfo typeVariable) {
        if (context instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo parameterizedContext = (ParameterizedTypeInfo)context;
            TypeInfo rawType = parameterizedContext.getRawType();
            if (!rawType.equals(typeVariable.getGenericDeclaration())) {
                TypeInfo resolvedTypeVariable = Utils.resolve(rawType, typeVariable);
                if (resolvedTypeVariable instanceof TypeVariableInfo) {
                    if (resolvedTypeVariable.equals(typeVariable)) {
                        return resolvedTypeVariable;
                    }
                    return Utils.resolve(context, (TypeVariableInfo)resolvedTypeVariable);
                }
                return resolvedTypeVariable;
            }
            int index = 0;
            for (TypeVariableInfo typeVariableParameter : typeVariable.getGenericDeclaration().getTypeParameters()) {
                if (!typeVariable.equals(typeVariableParameter)) continue;
                return (TypeInfo)parameterizedContext.getTypeArguments().get(index);
            }
            throw new AssertionError();
        }
        if (context instanceof ClassTypeInfo) {
            ClassTypeInfo classContext = (ClassTypeInfo)context;
            for (TypeInfo implementedInterface : classContext.getInterfaces()) {
                TypeInfo resolvedType = Utils.resolve(implementedInterface, typeVariable);
                if (resolvedType.equals(typeVariable)) continue;
                return resolvedType;
            }
            TypeInfo superClass = classContext.getSuperType();
            if (superClass != null) {
                return Utils.resolve(superClass, typeVariable);
            }
            return typeVariable;
        }
        throw new UnsupportedOperationException();
    }
}

