/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.spi.model.TypeModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeKind;
import org.reflext.api.TypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class TypeDomain<T, M> {

  /** . */
  final TypeModel<T> typeModel;

  /** . */
  final MethodModel<T, M> methodModel;

  public TypeDomain(TypeModel<T> typeModel, MethodModel<T, M> methodModel) {
    this.typeModel = typeModel;
    this.methodModel = methodModel;
  }

  public TypeInfo getType(T type) throws NullPointerException {
    if (type == null) {
      throw new NullPointerException("No null type accepted");
    }
    return _getType(type);
  }

  TypeInfoImpl<T, M> _getType(T type) {
    TypeKind kind = typeModel.getKind(type);
    switch (kind) {
      case SIMPLE:
        return new SimpleTypeInfoImpl<T, M>(this, type);
      case VOID:
        return new VoidTypeInfoImpl<T, M>(this, type);
      case CLASS:
        return new ClassTypeInfoImpl<T, M>(this, type);
      case PARAMETERIZED:
        return new ParameterizedTypeInfoImpl<T, M>(this, type);
      case VARIABLE:
        return new TypeVariableInfoImpl<T, M>(this, type);
      case WILDCARD:
        return new WildcardTypeInfoImpl<T, M>(this, type);
      case ARRAY:
        return new ArrayTypeInfoImpl<T, M>(this, type);
      default:
        throw new AssertionError("Cannot handle type " + type + " with kind " + kind);
    }
  }
}
