/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.MethodType;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.core.AnnotatedDelegate;
import org.reflext.core.ReflectedObject;
import org.reflext.core.TypeResolverImpl;
import org.reflext.core.TypeVariableInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodInfoImpl<T, M, A, P, F>
extends ReflectedObject<T, M, A, P, F>
implements MethodInfo {
    private static final List<String> NO_NAMES_AVAILABLE = new ArrayList<String>();
    private final M method;
    private final String name;
    private TypeInfo returnType;
    private List<TypeInfo> parameterTypes;
    private final AccessScope access;
    private final boolean _final;
    private final boolean _static;
    private final MethodType type;
    private final ClassTypeInfo owner;
    private MethodSignature signature;
    private List<TypeVariableInfo> typeParameters;
    private List<String> parameterNames;
    private AnnotatedDelegate<T, M, A, P, F, M> annotatedDelegate;

    public MethodInfoImpl(ClassTypeInfo owner, TypeResolverImpl<T, M, A, P, F> domain, M method) {
        super(domain);
        MethodType type = domain.methodModel.isAbstract(method) ? MethodType.ABSTRACT : (domain.methodModel.isNative(method) ? MethodType.NATIVE : MethodType.CONCRETE);
        this.method = method;
        this.name = domain.methodModel.getName(method);
        this.access = domain.methodModel.getAccess(method);
        this._final = domain.methodModel.isFinal(method);
        this._static = domain.methodModel.isStatic(method);
        this.type = type;
        this.owner = owner;
        this.signature = null;
        this.typeParameters = null;
        this.parameterNames = null;
        this.annotatedDelegate = null;
    }

    public M unwrap() {
        return this.method;
    }

    public TypeInfo getReturnType() {
        if (this.returnType == null) {
            Object rt = this.domain.methodModel.getReturnType(this.method);
            this.returnType = this.domain.resolve(rt);
        }
        return this.returnType;
    }

    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            Iterable names = this.domain.methodModel.getParameterNames(this.method);
            if (names != null) {
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (String parameterName : names) {
                    parameterNames.add(parameterName);
                }
                this.parameterNames = Collections.unmodifiableList(parameterNames);
            } else {
                this.parameterNames = NO_NAMES_AVAILABLE;
            }
        }
        return this.parameterNames == NO_NAMES_AVAILABLE ? null : this.parameterNames;
    }

    public List<TypeInfo> getParameterTypes() {
        if (this.parameterTypes == null) {
            ArrayList<TypeInfo> parameterTypes = new ArrayList<TypeInfo>();
            for (Object parameterType : this.domain.methodModel.getParameterTypes(this.method)) {
                parameterTypes.add(this.domain.resolve(parameterType));
            }
            this.parameterTypes = Collections.unmodifiableList(parameterTypes);
        }
        return this.parameterTypes;
    }

    public AccessScope getAccess() {
        return this.access;
    }

    public boolean isAbstract() {
        return this.type == MethodType.ABSTRACT;
    }

    public boolean isNative() {
        return this.type == MethodType.NATIVE;
    }

    public boolean isConcrete() {
        return this.type == MethodType.CONCRETE;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isFinal() {
        return this._final;
    }

    public MethodType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ClassTypeInfo getOwner() {
        return this.owner;
    }

    public List<TypeVariableInfo> getTypeParameters() {
        if (this.typeParameters == null) {
            ArrayList<TypeVariableInfo> typeParameters = new ArrayList<TypeVariableInfo>();
            for (Object tv : this.domain.methodModel.getTypeParameters(this.method)) {
                TypeVariableInfoImpl typeParameter = (TypeVariableInfoImpl)this.domain._getType(tv);
                typeParameters.add(typeParameter);
            }
            this.typeParameters = typeParameters;
        }
        return this.typeParameters;
    }

    public MethodSignature getSignature() {
        if (this.signature == null) {
            this.signature = new MethodSignature(this.name, this.getParameterTypes());
        }
        return this.signature;
    }

    public MethodSignature getSignature(ClassTypeInfo context) {
        List<TypeInfo> parameterTypes = this.getParameterTypes();
        ArrayList<TypeInfo> resolvedParameterTypes = new ArrayList<TypeInfo>(parameterTypes.size());
        for (TypeInfo parameterTI : parameterTypes) {
            TypeInfo resolvedParameterTI = context.resolve(parameterTI);
            resolvedParameterTypes.add(resolvedParameterTI);
        }
        return new MethodSignature(this.name, resolvedParameterTypes);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodInfo) {
            MethodInfo that = (MethodInfo)obj;
            String thatName = that.getName();
            MethodSignature signature = this.getSignature();
            MethodSignature thatSignature = that.getSignature();
            return this.owner.equals(this.getOwner()) && this.name.equals(thatName) && signature.equals((Object)thatSignature);
        }
        return false;
    }

    public <AT> AT getDeclaredAnnotation(AnnotationType<AT, ?> annotationType) {
        if (this.annotatedDelegate == null) {
            this.annotatedDelegate = new AnnotatedDelegate(this.domain, this.domain.methodAnnotationModel, this.method);
        }
        return this.annotatedDelegate.getDeclaredAnnotation(this.method, annotationType);
    }

    public String toString() {
        return "MethodInfo[name=" + this.name + ",owner=" + this.owner + "]";
    }
}

