/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.TypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ArrayTypeInfoImpl<T, M, A, P, F> extends AbstractArrayTypeInfo<T, M, A, P, F> implements ArrayTypeInfo {

  /** . */
  private final T type;

  /** . */
  private TypeInfo componentType;


  public ArrayTypeInfoImpl(TypeResolverImpl<T, M, A, P, F> domain, T type) {
    super(domain);

    //
    this.type = type;
  }

  public Object unwrap() {
    return type;
  }

  public TypeInfo getComponentType() {
    if (componentType == null) {
      T componentType = domain.typeModel.getComponentType(type);
      this.componentType = domain._getType(componentType);
    }
    return componentType;
  }
}
