/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.core;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.annotation.AnnotationInfo;
import org.reflext.api.annotation.AnnotationParameterInfo;

import java.util.*;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class AnnotationInfoImpl<T, M, A, P, E> implements AnnotationInfo {

  /** . */
  private final AnnotatedDelegate<T, M, A, P, E> owner;

  /** . */
  private final ClassTypeInfo type;

  /** . */
  private final A annotation;

  private Map<String, AnnotationParameterInfoImpl<T, M, A, P, E, ?>> abc = null;

  public AnnotationInfoImpl(
    AnnotatedDelegate<T, M, A, P, E> owner,
    ClassTypeInfo type, A annotation) {

    //
    this.owner = owner;
    this.type = type;
    this.annotation = annotation;
  }

  public ClassTypeInfo getType() {
    return type;
  }

  private Map<String, AnnotationParameterInfoImpl<T, M, A, P, E, ?>> getMap() {
    if (abc == null) {
      LinkedHashMap<String, AnnotationParameterInfoImpl<T, M, A, P, E, ?>> abc = new LinkedHashMap<String, AnnotationParameterInfoImpl<T,M,A,P,E,?>>();
      for (P param : owner.annotationModel.getAnnotationParameters(annotation)) {
        AnnotationParameterInfoImpl<T, M, A, P, E, ?> aaa = new AnnotationParameterInfoImpl<T,M,A,P,E,Object>(owner, annotation, param);
        abc.put(aaa.getName(), aaa);
      }
      this.abc = Collections.unmodifiableMap(abc);
    }
    return abc;
  }

  public AnnotationParameterInfo<?> getParameter(String parameterName) {
    return getMap().get(parameterName);
  }

  public Collection<? extends AnnotationParameterInfo<?>> getParameters() {
    return getMap().values();
  }
}
