/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.TypeInfo;

import java.util.List;
import java.util.ArrayList;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
class WildcardTypeInfoImpl<T, M, A, P> extends AbstractWildcardType<T, M, A, P> {

  /** . */
  private final T wildcardType;
  
  /** . */
  private List<TypeInfo> upperBounds;

  /** . */
  private List<TypeInfo> lowerBounds;

  public WildcardTypeInfoImpl(TypeResolverImpl<T, M, A, P> domain, T wildcardType) {
    super(domain);

    //
    this.wildcardType = wildcardType;
  }

  public T getType() {
    return wildcardType;
  }

  public List<TypeInfo> getUpperBounds() {
    if (upperBounds == null) {
      List<TypeInfo> upperBounds = new ArrayList<TypeInfo>();
      for (T upperBound : domain.typeModel.getUpperBounds(wildcardType)) {
        upperBounds.add(domain.resolve(upperBound));
      }
      this.upperBounds = upperBounds;
    }
    return upperBounds;
  }

  public List<TypeInfo> getLowerBounds() {
    if (lowerBounds == null) {
      List<TypeInfo> lowerBounds = new ArrayList<TypeInfo>();
      for (T lowerBound : domain.typeModel.getLowerBounds(wildcardType)) {
        lowerBounds.add(domain.resolve(lowerBound));
      }
      this.lowerBounds = lowerBounds;
    }
    return lowerBounds;
  }
}
