/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.core;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.WildcardTypeInfo;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class AbstractParameterizedTypeInfo<T, M, A, P> extends AbstractTypeInfo<T, M, A, P> implements ParameterizedTypeInfo {

  protected AbstractParameterizedTypeInfo(TypeResolverImpl<T, M, A, P> domain) {
    super(domain);
  }

  public String getName() {
    return getRawType().getName();
  }

  public boolean isReified() {
    for (TypeInfo typeArgument : getTypeArguments()) {
      if (typeArgument instanceof WildcardTypeInfo) {
        WildcardTypeInfo wildcardTypeArgument = (WildcardTypeInfo)typeArgument;
        if (wildcardTypeArgument.getLowerBounds().isEmpty()) {
          switch (wildcardTypeArgument.getUpperBounds().size()) {
            case 1:
              TypeInfo ti = wildcardTypeArgument.getUpperBounds().get(0);
              if (!(ti instanceof ClassTypeInfo)) {
                break;
              }
              ClassTypeInfo cti = (ClassTypeInfo)ti;
              if (!cti.getName().equals(Object.class.getName())) {
                break;
              }
            case 0:
              continue;
            default:
          }
        }
      }
      return false;
    }
    return true;  
  }

  public TypeInfo getOwnerType() {
    throw new UnsupportedOperationException();
  }

  public final int hashCode() {
    int hashCode = getRawType().hashCode();
    for (TypeInfo typeArgument : getTypeArguments()) {
      hashCode = hashCode * 43 + typeArgument.hashCode();
    }
    return hashCode;
  }

  public final boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj instanceof ParameterizedTypeInfo) {
      ParameterizedTypeInfo that = (ParameterizedTypeInfo)obj;
      if (getRawType().equals(that.getRawType())) {
        List<TypeInfo> typeArguments = getTypeArguments();
        List<? extends TypeInfo> thatTypeArguments = that.getTypeArguments();
        if (typeArguments.size() == thatTypeArguments.size()) {
          int length = typeArguments.size();
          for (int i = 0;i < length;i++) {
            TypeInfo typeArgument = typeArguments.get(i);
            TypeInfo thatTypeArgument = thatTypeArguments.get(i);
            if (!typeArgument.equals(thatTypeArgument)) {
              return false;
            }
          }
        }
        return true;
      }
    }
    return false;
  }

  @Override
  public final String toString() {
    return "ParameterizedType[rawType" + getRawType() + ",typeArguments=" + getTypeArguments() + "]";
  }
}
