/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test;

import junit.framework.TestCase;

import java.lang.reflect.Type;
import java.lang.reflect.Method;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.HashMap;

import org.reflext.core.TypeDomain;
import org.reflext.jlr.JavaLangReflectTypeModel;
import org.reflext.jlr.JavaLangReflectMethodModel;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class AbstractTypeResolutionTestCase extends TestCase {

  /** . */
  protected final TypeDomain<Type, Method> domain = new TypeDomain<Type, Method>(new JavaLangReflectTypeModel(), new JavaLangReflectMethodModel());

  /** . */
  protected final Map<String, Type> types = new HashMap<String, Type>();

  protected abstract void configure();

  protected abstract ReflectUnitTest getUnitTest();

  protected final void add(Class clazz) {
    org.reflext.test.Type typeAnn = ((AnnotatedElement)clazz).getAnnotation(org.reflext.test.Type.class);
    if (typeAnn != null) {
      types.put(typeAnn.value(), clazz);
    }
  }

  protected final void add(Class clazz, String methodName) {
    for (Method method : clazz.getDeclaredMethods()) {
      org.reflext.test.Type typeAnn = method.getAnnotation(org.reflext.test.Type.class);
      if (typeAnn != null) {
        types.put(typeAnn.value(), method.getGenericReturnType());
      }
    }
  }

  public void testResolver() throws Exception {

    configure();

    ReflectUnitTest a = getUnitTest();

    TypeDomainExt<Type, Method> td = new TypeDomainExt<Type, Method>(domain, types);

    a.run(td);

  }

}
