/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test;

import org.reflext.api.TypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;

import junit.framework.Assert;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class ReflectUnitTest extends Assert {

  /** . */
  private TypeDomainExt domain;

  public final void run(TypeDomainExt domain) throws Exception {
    try {
      this.domain = domain;

      //
      execute();
    }
    finally {
      this.domain = null;
    }
  }

  protected final TypeInfo getTypeInfo(String typeId) {
    TypeInfo ti = domain.getTypeInfo(typeId);
    if (ti == null) {
      throw new AssertionError("Could not located type info with id " + typeId);
    }
    return ti;
  }

  protected final MethodInfo getMethodInfo(String methodId) {
    MethodInfo mi = domain.getMethodInfo(methodId);
    if (mi == null) {
      throw new AssertionError("Could not located method info with id " + methodId);
    }
    return mi;
  }

  protected final void compare(String left, Comparison comparison, String right) {
    ClassTypeInfo leftTI = (ClassTypeInfo)getTypeInfo(left);
    ClassTypeInfo rightTI = (ClassTypeInfo)getTypeInfo(right);
    switch (comparison) {
      case TO:
        assertFalse("Was not expecting to have " + leftTI + " assignable from " + rightTI, leftTI.isAssignableFrom(rightTI));
        assertTrue("Was expecting to have " + leftTI + " assignable to " + rightTI, rightTI.isAssignableFrom(leftTI));
        break;
      case SAME:
        assertTrue("Was expecting to have " + leftTI + " assignable from " + rightTI, leftTI.isAssignableFrom(rightTI));
        assertTrue("Was expecting to have " + leftTI + " assignable to " + rightTI, rightTI.isAssignableFrom(leftTI));
        break;
      case FROM:
        assertTrue("Was expecting to have " + leftTI + " assignable from " + rightTI, leftTI.isAssignableFrom(rightTI));
        assertFalse("Was not expecting to have " + leftTI + " assignable to " + rightTI, rightTI.isAssignableFrom(leftTI));
        break;
      case DIFFERENT:
        assertFalse("Was not expecting to have " + leftTI + " assignable from " + rightTI, leftTI.isAssignableFrom(rightTI));
        assertFalse("Was not expecting to have " + leftTI + " assignable to " + rightTI, rightTI.isAssignableFrom(leftTI));
        break;
    }
  }

  public enum Comparison {
    FROM, SAME, TO, DIFFERENT
  }

  protected abstract void execute() throws Exception;

}