/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test;

import org.reflext.api.TypeInfo;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class ResolverUnitTest extends ReflectUnitTest {

  public TypeInfo resolve(String contextId, String typeId) {
    TypeInfo typeInfo = getTypeInfo(typeId);
    assertNotNull("Could not find type for id " + typeId, typeInfo);
    TypeInfo contextInfo = getTypeInfo(contextId);
    assertNotNull("Could not find type for id " + contextId, contextInfo);
    assertTrue("Type " + contextId + " is not a class type", contextInfo instanceof ClassTypeInfo);
    return ((ClassTypeInfo)contextInfo).resolve(typeInfo);
  }

  public TypeInfo resolve(String contextId, TypeInfo typeInfo) {
    TypeInfo contextInfo = getTypeInfo(contextId);
    assertNotNull("Could not find type for id " + contextId, contextInfo);
    assertTrue("Type " + contextId + " is not a class type", contextInfo instanceof ClassTypeInfo);
    return ((ClassTypeInfo)contextInfo).resolve(typeInfo);
  }
}
