/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import javax.tools.JavaFileObject;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
final class FileKey {

  /** . */
  final JavaFileObject.Kind kind;

  /** . */
  final String name;

  public FileKey(JavaFileObject.Kind kind, String name) {
    if (kind == null) {
      throw new NullPointerException();
    }
    if (name == null) {
      throw new NullPointerException();
    }

    //
    this.kind = kind;
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    } else if (o instanceof FileKey) {
      FileKey that = (FileKey)o;
      return kind.equals(that.kind) && name.equals(that.name);
    } else {
      return false;
    }
  }

  @Override
  public int hashCode() {
    return kind.hashCode() ^ name.hashCode();
  }
}
