/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import java.io.File;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.reflext.test.CompilerResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    private final Set<Class<?>> classes;
    private final List<File> files;
    private final int pkgCount;
    private final JavaCompiler.CompilationTask task;
    private final DiagnosticCollector<JavaFileObject> diagnostics;
    private final StringWriter out;
    private final CompilerResult result;

    public Compiler(Set<Class<?>> classes) throws URISyntaxException {
        ArrayList<File> files = new ArrayList<File>();
        HashSet<String> pkgs = new HashSet<String>();
        for (Class<?> clazz : classes) {
            if (clazz.isMemberClass()) continue;
            pkgs.add(clazz.getPackage().getName());
            String path = clazz.getName().replace('.', '/') + ".java";
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url == null) {
                throw new AssertionError((Object)("Could not find source code " + path));
            }
            File fic = new File(url.toURI());
            if (!fic.exists()) {
                throw new AssertionError((Object)("Could not access source code " + url));
            }
            files.add(fic);
        }
        int pkgCount = 0;
        for (String pkg : pkgs) {
            String path = pkg.replace('.', '/') + "/package-info.java";
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url == null) continue;
            File fic = new File(url.toURI());
            if (!fic.exists()) {
                throw new AssertionError((Object)("Could not access source code " + url));
            }
            files.add(fic);
            ++pkgCount;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        CompilerResult result = new CompilerResult(compiler.getStandardFileManager(diagnostics, null, null));
        StringWriter out = new StringWriter();
        List<String> options = Arrays.asList("-source", "1.5", "-target", "1.5");
        JavaCompiler.CompilationTask task = compiler.getTask(out, result, diagnostics, options, null, compilationUnits);
        this.classes = classes;
        this.files = files;
        this.pkgCount = pkgCount;
        this.task = task;
        this.diagnostics = diagnostics;
        this.out = out;
        this.result = result;
    }

    public boolean compile(Processor processor) {
        if (processor != null) {
            this.task.setProcessors(Collections.singleton(processor));
        }
        return this.task.call();
    }

    public CompilerResult getResult() {
        return this.result;
    }

    public String getDiagnostic() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.files) {
            sb.append("file:").append(file.getAbsolutePath()).append("\n\n");
        }
        for (Diagnostic diagnostic : this.diagnostics.getDiagnostics()) {
            sb.append("msg:").append(diagnostic.getMessage(Locale.ENGLISH)).append("\n");
            sb.append("code:").append(diagnostic.getCode()).append("\n");
            sb.append("column:").append(diagnostic.getColumnNumber()).append("\n");
            sb.append("line:").append(diagnostic.getLineNumber()).append("\n");
            sb.append("start:").append(diagnostic.getStartPosition()).append("\n");
            sb.append("end:").append(diagnostic.getEndPosition()).append("\n");
            sb.append("kind:").append((Object)diagnostic.getKind()).append("\n\n");
        }
        sb.append("out:").append(this.out.getBuffer()).append("\n\n");
        return sb.toString();
    }
}

