/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import java.util.HashMap;
import java.util.Map;
import org.reflext.test.CompilerResult;
import org.reflext.test.LocalFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerClassLoader
extends ClassLoader {
    private final CompilerResult compilerResult;
    private final Map<String, Class<?>> cache;

    public CompilerClassLoader(ClassLoader classLoader, CompilerResult compilerResult) {
        super(classLoader);
        this.compilerResult = compilerResult;
        this.cache = new HashMap();
    }

    public CompilerClassLoader(CompilerResult compilerResult) {
        this.compilerResult = compilerResult;
        this.cache = new HashMap();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.cache.get(name);
        if (clazz == null) {
            LocalFileObject cf = this.compilerResult.getClassFile(name);
            if (cf == null) {
                clazz = super.loadClass(name, resolve);
            } else {
                byte[] bytes = cf.getBytes();
                clazz = this.defineClass(name, bytes, 0, bytes.length, null);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                this.cache.put(name, clazz);
                return clazz;
            }
        }
        return clazz;
    }
}

