/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.methodoverloading;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodOverloadingUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    ClassTypeInfo ti = (ClassTypeInfo)getInfo("B");
    assertEquals(1, ti.getDeclaredMethods().size());
    MethodInfo m1 = ti.getDeclaredMethods().get(0);
    assertEquals("m1", m1.getName());
    ClassTypeInfo m1rt = (ClassTypeInfo)m1.getReturnType();
    assertEquals(ClassCastException.class.getName(), m1rt.getName());
  }
}
