/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.introspector.method;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.introspection.HierarchyScope;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodIntrospectorUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    testExactOverrideClass();
    testCovariantReturnTypeClass();
    testCovariantReturnTypeFull();
    testTypeVariableOverrideClass();
    testTypeVariableOverrideFull();
    testCovariantReturnTypeWithParallelHierarchy();
  }

  private void testCovariantReturnTypeWithParallelHierarchy() {
    TypeInfo bti = getTypeInfo("E2Impl");
    MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL, true);
    Collection mis = spector.getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("E2Impl_m1")), mis);
  }

  public void testExactOverrideClass() {
    TypeInfo bti = getTypeInfo("D2");
    MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
    Collection mis = spector.getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("D2_m1")), mis);
  }

  public void testExactOverrideFull() {
    TypeInfo bti = getTypeInfo("D2");
    MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL);
    Collection mis = spector.getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("D2_m1")), mis);
  }

  private void testCovariantReturnTypeClass() {
    TypeInfo bti = getTypeInfo("A2");
    MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
    Collection mis = spector.getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("A2_m1")), mis);
  }

  private void testCovariantReturnTypeFull() {
    TypeInfo bti = getTypeInfo("A2");
    MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL);
    Collection mis = spector.getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("A2_m1")), mis);
  }

  private void testTypeVariableOverrideClass() {
    TypeInfo bti = getTypeInfo("B2");

    //
    Collection mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("B2_m1")), mis);

    //
    mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(bti);
    assertEquals(Collections.singleton(getMethodInfo("B2_m1")), mis);

    //
    TypeInfo cti = getTypeInfo("C2");

    //
    mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(cti);
    assertEquals(Collections.singleton(getMethodInfo("C2_m1")), mis);

    //
    mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(cti);
    assertEquals(Collections.singleton(getMethodInfo("C2_m1")), mis);
  }

  private void testTypeVariableOverrideFull() {
    TypeInfo bti = getTypeInfo("B2");

    //
    Collection mis = new MethodIntrospector(HierarchyScope.ALL).getMethods(bti);
    Set<MethodInfo> methods = new HashSet<MethodInfo>();
    methods.add(getMethodInfo("B1_m1"));
    methods.add(getMethodInfo("B2_m1"));
    assertEquals(methods, mis);

    //
    mis = new MethodIntrospector(HierarchyScope.ALL, true).getMethods(bti);
    methods = new HashSet<MethodInfo>();
    methods.add(getMethodInfo("B2_m1"));
    assertEquals(methods, mis);

    //
    TypeInfo cti = getTypeInfo("C2");

    //
    mis = new MethodIntrospector(HierarchyScope.ALL).getMethods(cti);
    methods = new HashSet<MethodInfo>();
    methods.add(getMethodInfo("C1_m1"));
    methods.add(getMethodInfo("C2_m1"));
    assertEquals(methods, mis);

    //
    mis = new MethodIntrospector(HierarchyScope.ALL, true).getMethods(cti);
    methods = new HashSet<MethodInfo>();
    methods.add(getMethodInfo("C2_m1"));
    assertEquals(methods, mis);
  }
}