/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.introspector.method;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.introspection.HierarchyScope;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.test.ReflectUnitTest;

public class MethodIntrospectorUnitTest
extends ReflectUnitTest {
    protected void execute() throws Exception {
        this.testExactOverrideClass();
        this.testCovariantReturnTypeClass();
        this.testCovariantReturnTypeFull();
        this.testTypeVariableOverrideClass();
        this.testTypeVariableOverrideFull();
        this.testCovariantReturnTypeWithParallelHierarchy();
    }

    private void testCovariantReturnTypeWithParallelHierarchy() {
        TypeInfo bti = this.getTypeInfo("E2Impl");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL, true);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("E2Impl_m1")), (Object)mis);
    }

    public void testExactOverrideClass() {
        TypeInfo bti = this.getTypeInfo("D2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("D2_m1")), (Object)mis);
    }

    public void testExactOverrideFull() {
        TypeInfo bti = this.getTypeInfo("D2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("D2_m1")), (Object)mis);
    }

    private void testCovariantReturnTypeClass() {
        TypeInfo bti = this.getTypeInfo("A2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.CLASS);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("A2_m1")), (Object)mis);
    }

    private void testCovariantReturnTypeFull() {
        TypeInfo bti = this.getTypeInfo("A2");
        MethodIntrospector spector = new MethodIntrospector(HierarchyScope.ALL);
        Set mis = spector.getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("A2_m1")), (Object)mis);
    }

    private void testTypeVariableOverrideClass() {
        TypeInfo bti = this.getTypeInfo("B2");
        Set mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("B2_m1")), (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(bti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("B2_m1")), (Object)mis);
        TypeInfo cti = this.getTypeInfo("C2");
        mis = new MethodIntrospector(HierarchyScope.CLASS).getMethods(cti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("C2_m1")), (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.CLASS, true).getMethods(cti);
        MethodIntrospectorUnitTest.assertEquals(Collections.singleton(this.getMethodInfo("C2_m1")), (Object)mis);
    }

    private void testTypeVariableOverrideFull() {
        TypeInfo bti = this.getTypeInfo("B2");
        Set mis = new MethodIntrospector(HierarchyScope.ALL).getMethods(bti);
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
        methods.add(this.getMethodInfo("B1_m1"));
        methods.add(this.getMethodInfo("B2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.ALL, true).getMethods(bti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("B2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        TypeInfo cti = this.getTypeInfo("C2");
        mis = new MethodIntrospector(HierarchyScope.ALL).getMethods(cti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("C1_m1"));
        methods.add(this.getMethodInfo("C2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
        mis = new MethodIntrospector(HierarchyScope.ALL, true).getMethods(cti);
        methods = new HashSet();
        methods.add(this.getMethodInfo("C2_m1"));
        MethodIntrospectorUnitTest.assertEquals(methods, (Object)mis);
    }
}

