/*
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.field;

import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.test.ReflectUnitTest;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class FieldUnitTest extends ReflectUnitTest {

  @Override
  protected void execute() throws Exception {
    testNames();
    testAccessMode();
    testType();
    testModifiers();
    testAnnotations();
  }

  public void testAnnotations() throws Exception {
    ClassTypeInfo ecti = (ClassTypeInfo)getTypeInfo("E");
    FieldInfo a = ecti.getDeclaredField("a");
    Deprecated deprecated = a.getDeclaredAnnotation(AnnotationType.get(Deprecated.class));
    assertNotNull(deprecated);
  }

  public void testModifiers() throws Exception {
    ClassTypeInfo dcti = (ClassTypeInfo)getTypeInfo("D");
    FieldInfo a = dcti.getDeclaredField("a");
    assertEquals(false, a.isFinal());
    assertEquals(false, a.isStatic());
    FieldInfo b = dcti.getDeclaredField("b");
    assertEquals(true, b.isFinal());
    assertEquals(false, b.isStatic());
    FieldInfo c = dcti.getDeclaredField("c");
    assertEquals(true, c.isFinal());
    assertEquals(true, c.isStatic());
    FieldInfo d = dcti.getDeclaredField("d");
    assertEquals(false, d.isFinal());
    assertEquals(true, d.isStatic());
  }

  public void testNames() throws Exception {
    ClassTypeInfo ccti = (ClassTypeInfo)getTypeInfo("C");
    Map<String,  FieldInfo> fields = new HashMap<String, FieldInfo>();
    for (FieldInfo fi : ccti.getDeclaredFields()) {
      fields.put(fi.getName(), fi);
    }
    assertEquals(2, fields.size());
    assertEquals("a", fields.get("a").getName());
    assertEquals("b", fields.get("b").getName());
  }

  public void testType() {
    ClassTypeInfo acti = (ClassTypeInfo)getTypeInfo("A");
    ClassTypeInfo bcti = (ClassTypeInfo)getTypeInfo("B");
    assertEquals(acti, bcti.getDeclaredField("a").getType());
  }

  public void testAccessMode() {
    ClassTypeInfo cti = (ClassTypeInfo)getTypeInfo("A");
    FieldInfo a = cti.getDeclaredField("a");
    assertEquals(AccessScope.PUBLIC, a.getAccess());
    FieldInfo b = cti.getDeclaredField("b");
    assertEquals(AccessScope.PRIVATE, b.getAccess());
    FieldInfo c = cti.getDeclaredField("c");
    assertEquals(AccessScope.PROTECTED, c.getAccess());
    FieldInfo d = cti.getDeclaredField("d");
    assertEquals(AccessScope.PACKAGE_PROTECTED, d.getAccess());
  }
}
