/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.boundedtypevariable;

import org.reflext.test.ResolverUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class BoundedTypeVariableUnitTest extends ResolverUnitTest {

  protected void execute() throws Exception {
    testA();
    testB();
    testC();
    testD();
    testE();
    testF();
  }

  private void testA() {
    TypeInfo rt1 = resolve("A", "A_m1");
    assertTypeVariable(rt1, "X", Exception.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("A", "A_m2")).getTypeArguments().get(0);
    assertTypeVariable(rt2, "X", Exception.class);
  }
  
  private void testB() {
    TypeInfo rt1 = resolve("B", "A_m1");
    assertClassType(rt1, ClassNotFoundException.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("B", "A_m2")).getTypeArguments().get(0);
    assertClassType(rt2, ClassNotFoundException.class);
  }

  private void testC() {
    TypeInfo rt1 = resolve("C", "A_m1");
    assertTypeVariable(rt1, "Y", Exception.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("C", "A_m2")).getTypeArguments().get(0);
    assertTypeVariable(rt2, "Y", Exception.class);
  }

  private void testD() {
    TypeInfo rt1 = resolve("D", "A_m1");
    assertClassType(rt1, ClassNotFoundException.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("D", "A_m2")).getTypeArguments().get(0);
    assertClassType(rt2, ClassNotFoundException.class);
  }

  private void testE() {
    TypeInfo rt1 = resolve("E", "A_m1");
    assertTypeVariable(rt1, "Y", RuntimeException.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("E", "A_m2")).getTypeArguments().get(0);
    assertTypeVariable(rt2, "Y", RuntimeException.class);
  }

  private void testF() {
    TypeInfo rt1 = resolve("F", "A_m1");
    assertClassType(rt1, ClassCastException.class);
    TypeInfo rt2 = ((ParameterizedTypeInfo)resolve("F", "A_m2")).getTypeArguments().get(0);
    assertClassType(rt2, ClassCastException.class);
  }

  private void assertTypeVariable(TypeInfo typeInfo, String letter, Class<?> classBound) {
    assertTrue("Was expecting type to be variable instead of " + typeInfo, typeInfo instanceof TypeVariableInfo);
    TypeVariableInfo tv1 = (TypeVariableInfo)typeInfo;
    assertEquals(letter, tv1.getVariableName());
    List<TypeInfo> bounds = tv1.getBounds();
    assertEquals(1, bounds.size());
    TypeInfo bound = bounds.get(0);
    assertTrue(bound instanceof ClassTypeInfo);
    ClassTypeInfo boundCTI = (ClassTypeInfo)bound;
    assertEquals(classBound.getName(), boundCTI.getName());
  }

  private void assertClassType(TypeInfo typeInfo, Class clazz) {
    assertTrue("Was expecting type to be class instead of " + typeInfo, typeInfo instanceof ClassTypeInfo);
    ClassTypeInfo tv1 = (ClassTypeInfo)typeInfo;
    assertEquals(clazz.getName(), tv1.getName());
  }
}
