/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.wildcardtype;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.WildcardTypeInfo;
import org.reflext.test.ReflectUnitTest;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class WildcardUnitTest extends ReflectUnitTest {

  private WildcardTypeInfo getWildcardType(String typeId) {
    ParameterizedTypeInfo typeInfo = (ParameterizedTypeInfo)getTypeInfo(typeId);
    return (WildcardTypeInfo)typeInfo.getTypeArguments().get(0);
  }

  private void assertBlah(WildcardTypeInfo wildcard) {
    if (wildcard.getUpperBounds().isEmpty()) {
      // OK
    } else if (wildcard.getUpperBounds().size() == 1) {
      ClassTypeInfo cti = (ClassTypeInfo)wildcard.getUpperBounds().get(0);
      assertEquals(Object.class.getName(), cti.getName());
    } else {
      fail();
    }
  }

  @Override
  protected void execute() throws Exception {
    WildcardTypeInfo m1 = getWildcardType("m1");
    assertBlah(m1);
    assertTrue(m1.getLowerBounds().isEmpty());

    //
    WildcardTypeInfo m2 = getWildcardType("m2");
    assertEquals(1, m2.getUpperBounds().size());
    assertEquals(0, m2.getLowerBounds().size());

    //
    WildcardTypeInfo m3 = getWildcardType("m3");
    assertBlah(m3);
    assertEquals(1, m3.getLowerBounds().size());
    assertEquals(Object.class.getName(), ((ClassTypeInfo)m3.getLowerBounds().get(0)).getName());

    //
    WildcardTypeInfo m4 = getWildcardType("m4");
    assertEquals(1, m4.getUpperBounds().size());
    assertEquals(Number.class.getName(), ((ClassTypeInfo)m4.getUpperBounds().get(0)).getName());
    assertEquals(0, m4.getLowerBounds().size());

    //
    WildcardTypeInfo m5 = getWildcardType("m5");
    assertBlah(m5);
    assertEquals(1, m5.getLowerBounds().size());
    assertEquals(Number.class.getName(), ((ClassTypeInfo)m5.getLowerBounds().get(0)).getName());
  }
}