/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.classtype;

import org.reflext.api.ClassTypeInfo;
import org.reflext.test.ReflextUnitTest;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ClassTypeUnitTest extends ReflextUnitTest {

  @Override
  protected void execute() throws Exception {
    ClassTypeInfo a = (ClassTypeInfo)getTypeInfo("A");
    ClassTypeInfo b = (ClassTypeInfo)getTypeInfo("B");
    ClassTypeInfo c = (ClassTypeInfo)getTypeInfo("C");
    ClassTypeInfo d$e = (ClassTypeInfo)getTypeInfo("D$E");

    // Simple name
    assertEquals("A", a.getSimpleName());
    assertEquals("A$B", b.getSimpleName());
    assertEquals("A$B$C", c.getSimpleName());
    assertEquals("A$D$E", d$e.getSimpleName());

    // Name
    assertEquals("org.reflext.test.conformance.classtype.A", a.getName());
    assertEquals("org.reflext.test.conformance.classtype.A$B", b.getName());
    assertEquals("org.reflext.test.conformance.classtype.A$B$C", c.getName());
    assertEquals("org.reflext.test.conformance.classtype.A$D$E", d$e.getName());

    // Enclosing
    assertEquals(null, a.getEnclosing());
    assertEquals(a, b.getEnclosing());
    assertEquals(b, c.getEnclosing());
    assertEquals(a, d$e.getEnclosing());
  }
}
