/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.methodparametertypes;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeVariableInfo;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodParameterTypesUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    ClassTypeInfo ti = (ClassTypeInfo)getTypeInfo("A");
    Map<String, MethodInfo> methodMap = new HashMap<String, MethodInfo>();
    for (MethodInfo method : ti.getDeclaredMethods()) {
      methodMap.put(method.getName(), method);
    }

    //
    MethodInfo m1 = methodMap.get("m1");
    assertEquals(0, m1.getParameterTypes().size());

    //
    MethodInfo m2 = methodMap.get("m2");
    assertEquals(1, m2.getParameterTypes().size());
    ClassTypeInfo m2_0 = (ClassTypeInfo)m2.getParameterTypes().get(0);
    assertEquals(String.class.getName(), m2_0.getName());

    //
    MethodInfo m3 = methodMap.get("m3");
    assertEquals(1, m3.getParameterTypes().size());
    TypeVariableInfo m3_0 = (TypeVariableInfo)m3.getParameterTypes().get(0);
    assertEquals("X", m3_0.getVariableName());

    //
    MethodInfo m4 = methodMap.get("m4");
    assertEquals(1, m4.getParameterTypes().size());
    TypeVariableInfo m4_0 = (TypeVariableInfo)m4.getParameterTypes().get(0);
    assertEquals("Y", m4_0.getVariableName());
  }

}