/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.methodthrowntypes;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.test.ReflextUnitTest;

import java.io.IOException;
import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodThrownTypesUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    MethodInfo mi = getMethodInfo("m");
    List<ClassTypeInfo> thrownTypes = mi.getThrownTypes();
    assertEquals(1, thrownTypes.size());
    ClassTypeInfo thrownType = thrownTypes.get(0);
    assertEquals(IOException.class.getName(), thrownType.getName());
  }

}