/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.multipletypevariable;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeVariableInfo;

import java.util.List;
import java.io.Serializable;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MultipleTypeVariableUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    TypeInfo info = getTypeInfo("A");
    assertTrue(info instanceof ClassTypeInfo);
    ClassTypeInfo cti = (ClassTypeInfo)info;
    List<TypeVariableInfo> list =  cti.getTypeParameters();
    assertEquals(1, list.size());
    TypeVariableInfo tvi = list.get(0);
    assertEquals("X", tvi.getVariableName());
    List<TypeInfo> bounds = tvi.getBounds();
    assertEquals(2, bounds.size());
    TypeInfo bound1 = bounds.get(0);
    assertTrue(bound1 instanceof ClassTypeInfo);
    assertEquals(Exception.class.getName(), ((ClassTypeInfo)bound1).getName());
    TypeInfo bound2 = bounds.get(1);
    assertTrue(bound2 instanceof ClassTypeInfo);
    assertEquals(Serializable.class.getName(), ((ClassTypeInfo)bound2).getName());
  }
}
