/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.signature;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.MethodInfo;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class SignatureUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    testTypeVariableImplicitResolution();
    testTypeVariableExplicitResolution();
  }

  private void testTypeVariableImplicitResolution() {
    MethodInfo am1 = getMethodInfo("A_m1");
    MethodInfo bm1 = getMethodInfo("B_m1");
    MethodInfo am2 = getMethodInfo("A_m2");
    MethodInfo bm2 = getMethodInfo("B_m2");
    assertEquals(am1.getSignature(), bm1.getSignature());
    assertEquals(am2.getSignature(), bm2.getSignature());
  }

  private void testTypeVariableExplicitResolution() {
    ClassTypeInfo d = (ClassTypeInfo)getTypeInfo("D");
    MethodInfo cm1 = getMethodInfo("C_m1");
    MethodInfo dm1 = getMethodInfo("D_m1");
    assertEquals(cm1.getSignature(d), dm1.getSignature());
  }
}
