/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.simpletype;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.LiteralType;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class SimpleTypeUnitTest extends ReflextUnitTest {

  private void assertSimple(String id, LiteralType literalType, boolean primitive, Class expectedClass) {
    TypeInfo typeInfo = getTypeInfo(id);
    assertTrue(typeInfo instanceof SimpleTypeInfo);
    SimpleTypeInfo simpleType = (SimpleTypeInfo)typeInfo;
    assertEquals(literalType, simpleType.getLiteralType());
    assertEquals(primitive, simpleType.isPrimitive());
    assertEquals(expectedClass.getName(), simpleType.getName());
  }

  protected void execute() throws Exception {
    testTypes();
  }

  private void testTypes() {
    assertSimple("boolean", LiteralType.BOOLEAN, true, boolean.class);
    assertSimple("byte", LiteralType.BYTE, true, byte.class);
    assertSimple("short", LiteralType.SHORT, true, short.class);
    assertSimple("int", LiteralType.INT, true, int.class);
    assertSimple("long", LiteralType.LONG, true, long.class);
    assertSimple("float", LiteralType.FLOAT, true, float.class);
    assertSimple("double", LiteralType.DOUBLE, true, double.class);
    assertSimple("Boolean", LiteralType.BOOLEAN, false, Boolean.class);
    assertSimple("Byte", LiteralType.BYTE, false, Byte.class);
    assertSimple("Short", LiteralType.SHORT, false, Short.class);
    assertSimple("Integer", LiteralType.INT, false, Integer.class);
    assertSimple("Long", LiteralType.LONG, false, Long.class);
    assertSimple("Float", LiteralType.FLOAT, false, Float.class);
    assertSimple("Double", LiteralType.DOUBLE, false, Double.class);
  }
}