/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.arraytype;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ArrayTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ArrayTypeUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    testA();
    testB();
  }

  private void testA() {
    TypeInfo ti1 = resolve("A", "A_m1");
    assertTrue(ti1 instanceof ArrayTypeInfo);
    ArrayTypeInfo pt1 = (ArrayTypeInfo)ti1;
    TypeInfo tas1 = pt1.getComponentType();
    assertTrue(tas1 instanceof TypeVariableInfo);
    assertEquals("X", ((TypeVariableInfo)tas1).getVariableName());

    //
    TypeInfo ti2 = resolve("A", "A_m2");
    assertTrue(ti2 instanceof ArrayTypeInfo);
    ArrayTypeInfo pt2 = (ArrayTypeInfo)ti2;
    TypeInfo tas2 = pt2.getComponentType();
    assertTrue(tas2 instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)tas2).getName());
  }

  private void testB() {
    TypeInfo ti1 = resolve("B", "A_m1");
    assertTrue(ti1 instanceof ArrayTypeInfo);
    ArrayTypeInfo pt1 = (ArrayTypeInfo)ti1;
    TypeInfo tas1 = pt1.getComponentType();
    assertTrue(tas1 instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)tas1).getName());

    //
    TypeInfo ti2 = resolve("B", "A_m2");
    assertTrue(ti2 instanceof ArrayTypeInfo);
    ArrayTypeInfo pt2 = (ArrayTypeInfo)ti2;
    TypeInfo tas2 = pt2.getComponentType();
    assertTrue(tas2 instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)tas2).getName());

/*
    TypeInfo ti1 = resolve("B", "A_m1");
    assertTrue(ti1 instanceof ParameterizedTypeInfo);
    ParameterizedTypeInfo pt1 = (ParameterizedTypeInfo)ti1;
    List<? extends TypeInfo> tas1 = pt1.getTypeArguments();
    assertEquals(1, tas1.size());
    assertTrue(tas1.get(0) instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)tas1.get(0)).getName());

    //
    TypeInfo ti2 = resolve("B", "A_m2");
    assertTrue(ti2 instanceof ParameterizedTypeInfo);
    ParameterizedTypeInfo pt2 = (ParameterizedTypeInfo)ti2;
    List<? extends TypeInfo> tas2 = pt2.getTypeArguments();
    assertEquals(1, tas2.size());
    assertTrue(tas2.get(0) instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)tas2.get(0)).getName());
*/
  }
}