/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.classtype;

import org.reflext.api.TypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.test.ReflextUnitTest;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ClassTypeUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    TypeInfo ti1 = resolve("C", "C_m1");
    assertTrue(ti1 instanceof ClassTypeInfo);
    ClassTypeInfo cti1 = (ClassTypeInfo)ti1;
    assertEquals("org.reflext.test.resolver.classtype.A", cti1.getName());

    //
    TypeInfo ti2 = resolve("C", "C_m2");
    assertTrue(ti2 instanceof ClassTypeInfo);
    ClassTypeInfo cti2 = (ClassTypeInfo)ti2;
    assertEquals("org.reflext.test.resolver.classtype.B", cti2.getName());
  }
}
