/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.methodtypevariable;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.ClassTypeInfo;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodTypeVariableUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {
    TypeInfo typeInfo = resolve("A", "A_m1");
    assertTrue("Was expecting type to be variable instead of " + typeInfo, typeInfo instanceof TypeVariableInfo);
    TypeVariableInfo tv1 = (TypeVariableInfo)typeInfo;
    assertEquals("X", tv1.getVariableName());
    List<TypeInfo> bounds = tv1.getBounds();
    assertEquals(1, bounds.size());
    TypeInfo bound = bounds.get(0);
    assertTrue(bound instanceof ClassTypeInfo);
    ClassTypeInfo boundCTI = (ClassTypeInfo)bound;
    assertEquals(Object.class.getName(), boundCTI.getName());
  }
}