/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.resolver.wildcardtype;

import org.reflext.test.ReflextUnitTest;
import org.reflext.api.TypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.WildcardTypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class WildcardTypeUnitTest extends ReflextUnitTest {

  protected void execute() throws Exception {

    ParameterizedTypeInfo A_m1 = (ParameterizedTypeInfo)getTypeInfo("A_m1");
    TypeInfo tv1 = A_m1.getTypeArguments().get(0);

    //
    TypeInfo rt1 = resolve("A", tv1);
    assertTrue(rt1 instanceof WildcardTypeInfo);
    WildcardTypeInfo wt1 = (WildcardTypeInfo)rt1;
    assertEquals(1, wt1.getUpperBounds().size());
    assertEquals(0, wt1.getLowerBounds().size());
    TypeInfo tmp = wt1.getUpperBounds().get(0);
    assertTrue(tmp instanceof TypeVariableInfo);
    TypeVariableInfo tmp2 = (TypeVariableInfo)tmp;
    assertEquals("X", tmp2.getVariableName());

    //
    TypeInfo rt2 = resolve("B", tv1);
    assertTrue(rt2 instanceof WildcardTypeInfo);
    WildcardTypeInfo wt2 = (WildcardTypeInfo)rt2;
    assertEquals(1, wt2.getUpperBounds().size());
    assertEquals(0, wt2.getLowerBounds().size());
    TypeInfo tmp3 = wt2.getUpperBounds().get(0);
    assertTrue(tmp3 instanceof ClassTypeInfo);
    ClassTypeInfo tmp4 = (ClassTypeInfo)tmp3;
    assertEquals(String.class.getName(), tmp4.getName());
  }
}
