/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.restlet.Request;
import org.restlet.Response;

public class ChallengeCallbackHandler
implements CallbackHandler {
    private volatile Request request;
    private volatile Response response;

    public ChallengeCallbackHandler(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    protected void handle(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof PasswordCallback) {
            PasswordCallback pc = (PasswordCallback)callback;
            if (this.getRequest().getChallengeResponse() != null) {
                pc.setPassword(this.getRequest().getChallengeResponse().getSecret());
            }
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                this.handle(callback);
            }
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }
}

