/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.edm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.ext.odata.internal.edm.AssociationEnd;
import org.restlet.ext.odata.internal.edm.ComplexType;
import org.restlet.ext.odata.internal.edm.EntityContainer;
import org.restlet.ext.odata.internal.edm.EntitySet;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Mapping;
import org.restlet.ext.odata.internal.edm.MetadataReader;
import org.restlet.ext.odata.internal.edm.NavigationProperty;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.edm.Schema;
import org.restlet.ext.odata.internal.edm.TypeUtils;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata
extends SaxRepresentation {
    private List<EntityContainer> containers;
    private List<Mapping> mappings;
    private Reference metadataRef;
    private List<Schema> schemas;

    public Metadata(Representation metadata, Reference metadataRef) throws IOException {
        super(metadata);
        this.setNamespaceAware(true);
        this.metadataRef = metadataRef;
        this.parse(new MetadataReader(this));
    }

    public AssociationEnd getAssociation(EntityType type, String propertyName) {
        AssociationEnd result = null;
        for (NavigationProperty association : type.getAssociations()) {
            if (!association.getNormalizedName().equals(propertyName)) continue;
            result = association.getToRole();
            break;
        }
        return result;
    }

    public List<EntityContainer> getContainers() {
        if (this.containers == null) {
            this.containers = new ArrayList<EntityContainer>();
        }
        return this.containers;
    }

    public String getEntitySetSubpath(EntityType entityType) {
        String result = null;
        if (entityType == null) {
            return result;
        }
        for (EntityContainer entityContainer : this.getContainers()) {
            for (EntitySet entitySet : entityContainer.getEntities()) {
                EntityType type = entitySet.getType();
                if (!type.equals(entityType)) continue;
                result = "/" + entitySet.getName();
            }
        }
        return result;
    }

    public EntityType getEntityType(Class<?> entityClass) {
        EntityType result = null;
        String className = entityClass.getName();
        int index = className.lastIndexOf(".");
        if (index != -1) {
            className = className.substring(index + 1);
        }
        Iterator<EntityContainer> iec = this.getContainers().iterator();
        while (result == null && iec.hasNext()) {
            EntityContainer entityContainer = iec.next();
            Iterator<EntitySet> ies = entityContainer.getEntities().iterator();
            while (result == null && ies.hasNext()) {
                EntitySet entitySet = ies.next();
                EntityType type = entitySet.getType();
                if (!type.getClassName().equals(className)) continue;
                result = type;
            }
        }
        return result;
    }

    public ComplexType getComplexType(Class<?> entityClass) {
        ComplexType result = null;
        String className = entityClass.getName();
        int index = className.lastIndexOf(".");
        if (index != -1) {
            className = className.substring(index + 1);
        }
        Iterator<Schema> iec = this.getSchemas().iterator();
        while (result == null && iec.hasNext()) {
            Schema schema = iec.next();
            Iterator<ComplexType> ies = schema.getComplexTypes().iterator();
            while (result == null && ies.hasNext()) {
                ComplexType type = ies.next();
                if (!type.getClassName().equals(className)) continue;
                result = type;
            }
        }
        return result;
    }

    public String getKeyValue(EntityType type, Object entity) {
        StringBuffer result;
        block11: {
            result = new StringBuffer();
            if (type.getKeys() != null && !type.getKeys().isEmpty()) {
                if (type.getKeys().size() == 1) {
                    Property key = type.getKeys().get(0);
                    String keyName = key.getNormalizedName();
                    String getterName = "get" + keyName.substring(0, 1).toUpperCase() + keyName.substring(1);
                    try {
                        Method getter = entity.getClass().getDeclaredMethod(getterName, null);
                        Object value = getter.invoke(entity, (Object[])null);
                        String strValue = TypeUtils.toEdmKey(value, key.getType());
                        if (strValue != null) {
                            result.append(strValue);
                            break block11;
                        }
                        result.append("''");
                    }
                    catch (Exception e) {}
                } else {
                    Iterator<Property> it = type.getKeys().iterator();
                    while (it.hasNext()) {
                        Property key = it.next();
                        String keyName = key.getNormalizedName();
                        result.append(key.getName()).append("=");
                        String getterName = "get" + keyName.substring(0, 1).toUpperCase() + keyName.substring(1);
                        try {
                            Method getter = entity.getClass().getDeclaredMethod(getterName, null);
                            Object value = getter.invoke(entity, (Object[])null);
                            String strValue = TypeUtils.toEdmKey(value, key.getType());
                            if (strValue != null) {
                                result.append(strValue);
                            } else {
                                result.append("''");
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!it.hasNext()) continue;
                        result.append(",");
                    }
                }
            }
        }
        return result.toString();
    }

    public String getKeyValue(Object entity) {
        String result = null;
        if (entity != null) {
            result = this.getKeyValue(this.getEntityType(entity.getClass()), entity);
        }
        return result;
    }

    public List<Mapping> getMappings() {
        if (this.mappings == null) {
            this.mappings = new ArrayList<Mapping>();
        }
        return this.mappings;
    }

    public Reference getMetadataRef() {
        return this.metadataRef;
    }

    public Property getProperty(Object entity, String propertyName) {
        Property result;
        block2: {
            block3: {
                result = null;
                if (entity == null) break block2;
                EntityType et = this.getEntityType(entity.getClass());
                if (et == null) break block3;
                for (Property property : et.getProperties()) {
                    if (!property.getName().equals(propertyName) && !property.getNormalizedName().equals(propertyName)) continue;
                    result = property;
                    break block2;
                }
                break block2;
            }
            ComplexType ct = this.getComplexType(entity.getClass());
            if (ct == null) break block2;
            for (Property property : ct.getProperties()) {
                if (!property.getName().equals(propertyName) && !property.getNormalizedName().equals(propertyName)) continue;
                result = property;
                break;
            }
        }
        return result;
    }

    public List<Schema> getSchemas() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>();
        }
        return this.schemas;
    }

    public String getSubpath(Object entity) {
        String result = null;
        if (entity == null) {
            return result;
        }
        String entityClass = entity.getClass().getName();
        int index = entityClass.lastIndexOf(".");
        if (index != -1) {
            entityClass = entityClass.substring(index + 1);
        }
        for (EntityContainer entityContainer : this.getContainers()) {
            for (EntitySet entitySet : entityContainer.getEntities()) {
                String value;
                EntityType type = entitySet.getType();
                if (!type.getClassName().equals(entityClass) || (value = this.getKeyValue(type, entity)) == null) continue;
                result = "/" + entitySet.getName() + "(" + value + ")";
            }
        }
        return result;
    }

    public String getSubpath(Object entity, String propertyName) {
        return this.getSubpath(entity) + "/" + propertyName;
    }

    public String getSubpath(Object source, String sourceProperty, Object target) {
        return this.getSubpath(source) + "/" + sourceProperty + "(" + this.getKeyValue(target) + ")";
    }

    public void setContainers(List<EntityContainer> containers) {
        this.containers = containers;
    }

    public void setSchemas(List<Schema> schemas) {
        this.schemas = schemas;
    }
}

