/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RdfXmlWriter
extends GraphHandler {
    private final String RDF_SYNTAX = RdfConstants.RDF_SYNTAX.toString(true, true);
    private XmlWriter writer;

    public RdfXmlWriter(OutputStream outputStream, CharacterSet characterSet) throws UnsupportedEncodingException {
        this.writer = new XmlWriter(outputStream, characterSet == null ? CharacterSet.UTF_8.getName() : characterSet.getName());
    }

    public void endGraph() throws IOException {
        try {
            this.writer.endElement(this.RDF_SYNTAX, "RDF");
            this.writer.endDocument();
        }
        catch (SAXException e) {
            Context.getCurrentLogger().warning("Cannot write the end of the graph: " + e.getMessage());
        }
        this.writer.flush();
    }

    private String getNamespace(Reference reference) {
        String prefix = this.getPrefix(reference);
        String ref = reference.toString(true, true);
        if (prefix != null) {
            return ref.substring(0, ref.length() - prefix.length());
        }
        return ref;
    }

    private String getPrefix(Reference ref) {
        String result = null;
        result = ref.hasFragment() ? ref.getFragment() : ref.getLastSegment();
        return result;
    }

    public void link(Graph source, Reference typeRef, Literal target) {
        Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the subject is not a Reference.");
    }

    public void link(Graph source, Reference typeRef, Reference target) {
        Context.getCurrentLogger().warning("Cannot write the representation of a statement due to the fact that the subject is not a Reference.");
    }

    public void link(Reference source, Reference typeRef, Literal target) {
        try {
            this.writeNode(source, true);
            String typeRefNs = this.getNamespace(typeRef.getTargetRef());
            String typeRefPrefix = this.getPrefix(typeRef.getTargetRef());
            if (target.getLanguage() != null || target.getDatatypeRef() != null) {
                AttributesImpl attr = new AttributesImpl();
                if (target.getLanguage() != null) {
                    attr.addAttribute(null, "lang", "xml:lang", "text", target.getLanguage().getName());
                }
                if (target.getDatatypeRef() != null) {
                    attr.addAttribute(this.RDF_SYNTAX, "datatype", "rdf:datatype", "text", target.getDatatypeRef().toString(true, true));
                }
                this.writer.startElement(typeRefNs, typeRefPrefix, null, (Attributes)attr);
            } else {
                this.writer.startElement(typeRefNs, typeRefPrefix);
            }
            this.writer.characters(target.getValue());
            this.writer.endElement(typeRefNs, typeRefPrefix);
            this.writer.endElement(this.RDF_SYNTAX, "Description");
        }
        catch (SAXException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    public void link(Reference source, Reference typeRef, Reference target) {
        try {
            this.writeNode(source, true);
            String typeRefNs = this.getNamespace(typeRef.getTargetRef());
            String typeRefPrefix = this.getPrefix(typeRef.getTargetRef());
            this.writer.startElement(typeRefNs, typeRefPrefix);
            this.writeNode(target, false);
            this.writer.endElement(typeRefNs, typeRefPrefix);
            this.writer.endElement(this.RDF_SYNTAX, "Description");
        }
        catch (SAXException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }

    public void startGraph() throws IOException {
        this.writer.setPrefix(this.RDF_SYNTAX, "rdf");
        this.writer.setPrefix(RdfConstants.XML_SCHEMA.toString(true, true), "type");
        this.writer.setDataFormat(true);
        this.writer.setIndentStep(3);
        try {
            this.writer.startDocument();
            this.writer.startElement(this.RDF_SYNTAX, "RDF");
        }
        catch (SAXException e) {
            Context.getCurrentLogger().warning("Cannot write the start of the graph: " + e.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, Reference reference) {
        if (prefix == null) {
            this.writer.forceNSDecl(this.getNamespace(reference.getTargetRef()));
        } else {
            this.writer.forceNSDecl(this.getNamespace(reference.getTargetRef()), prefix);
        }
    }

    private void writeNode(Reference reference, boolean subject) {
        AttributesImpl atts = new AttributesImpl();
        if (Link.isBlankRef(reference)) {
            atts.addAttribute(this.RDF_SYNTAX, "NodeId", "rdf:NodeId", "text", reference.getTargetRef().toString(true, true));
        } else {
            atts.addAttribute(this.RDF_SYNTAX, "about", "rdf:about", "text", reference.getTargetRef().toString(true, true));
        }
        try {
            if (!subject) {
                this.writer.emptyElement(this.RDF_SYNTAX, "Description", "rdf:Description", (Attributes)atts);
            } else {
                this.writer.startElement(this.RDF_SYNTAX, "Description", "rdf:Description", (Attributes)atts);
            }
        }
        catch (SAXException e) {
            Context.getCurrentLogger().warning("Cannot write the representation of a statement due to: " + e.getMessage());
        }
    }
}

