/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip;

import java.net.URI;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.SipMethod;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.SipRequest;
import org.restlet.ext.sip.SipResponse;
import org.restlet.ext.sip.internal.SipInboundRequest;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipClientResource
extends ClientResource {
    public static <T> T create(Context context, Reference reference, Class<? extends T> resourceInterface) {
        SipClientResource clientResource = new SipClientResource(context, reference);
        return (T)clientResource.wrap(resourceInterface);
    }

    public static <T> T create(Reference reference, Class<? extends T> resourceInterface) {
        return SipClientResource.create(null, reference, resourceInterface);
    }

    public static <T> T create(String uri, Class<? extends T> resourceInterface) {
        return SipClientResource.create(null, new Reference(uri), resourceInterface);
    }

    public SipClientResource(Context context, URI uri) {
        this(context, SipMethod.INVITE, uri);
    }

    public SipClientResource(Context context, Method method, URI uri) {
        this(context, method, new Reference(uri));
    }

    public SipClientResource(Context context, Method method, Reference reference) {
        this(context, new SipRequest(method, reference), new SipResponse(null));
    }

    public SipClientResource(Context context, Method method, String uri) {
        this(context, method, new Reference(uri));
    }

    public SipClientResource(Context context, Reference reference) {
        this(context, SipMethod.INVITE, reference);
    }

    public SipClientResource(Context context, SipRequest request, SipResponse response) {
        super(context, (Request)request, (Response)response);
    }

    public SipClientResource(Context context, String uri) {
        this(context, SipMethod.INVITE, uri);
    }

    public SipClientResource(URI uri) {
        this(Context.getCurrent(), null, uri);
    }

    public SipClientResource(Method method, URI uri) {
        this(Context.getCurrent(), method, uri);
    }

    public SipClientResource(Method method, Reference reference) {
        this(Context.getCurrent(), method, reference);
    }

    public SipClientResource(Method method, String uri) {
        this(Context.getCurrent(), method, uri);
    }

    public SipClientResource(Reference reference) {
        this(Context.getCurrent(), null, reference);
    }

    public SipClientResource(SipClientResource resource) {
        SipRequest request = new SipRequest(resource.getRequest());
        SipResponse response = new SipResponse(request);
        this.setNext(resource.getNext());
        this.setFollowingRedirects(resource.isFollowingRedirects());
        this.setRetryOnError(resource.isRetryOnError());
        this.setRetryDelay(resource.getRetryDelay());
        this.setRetryAttempts(resource.getRetryAttempts());
        this.init(resource.getContext(), request, response);
    }

    public SipClientResource(SipRequest request, SipResponse response) {
        this(Context.getCurrent(), request, response);
    }

    public SipClientResource(String uri) {
        this(Context.getCurrent(), null, uri);
    }

    public void ack() throws ResourceException {
        this.handle(SipMethod.ACK);
    }

    public void ack(Representation representation) throws ResourceException {
        this.handle(SipMethod.ACK, representation);
    }

    public Representation bye() throws ResourceException {
        return this.handle(SipMethod.BYE);
    }

    public void cancel() throws ResourceException {
        this.handle(SipMethod.CANCEL);
    }

    public Request createRequest(Request prototype) {
        return new SipRequest((SipRequest)prototype);
    }

    protected Response createResponse(Request request) {
        return new SipResponse(request);
    }

    public String getCommandSequence() {
        return this.getRequest().getCommandSequence();
    }

    public Address getFrom() {
        return this.getRequest().getFrom();
    }

    public SipRequest getRequest() {
        return (SipRequest)super.getRequest();
    }

    public String getRequestCallId() {
        return this.getRequest().getCallId();
    }

    public SipResponse getResponse() {
        return (SipResponse)super.getResponse();
    }

    public String getResponseCallId() {
        return this.getResponse().getCallId();
    }

    public List<SipRecipientInfo> getSipRequestRecipientsInfo() {
        return this.getRequest().getSipRecipientsInfo();
    }

    public List<SipRecipientInfo> getSipResponseRecipientsInfo() {
        return this.getResponse().getSipRecipientsInfo();
    }

    public Address getTo() {
        return this.getRequest().getTo();
    }

    public Representation info() throws ResourceException {
        return this.handle(SipMethod.INFO);
    }

    public Representation info(Representation representation) throws ResourceException {
        return this.handle(SipMethod.INFO, representation);
    }

    public Representation invite() throws ResourceException {
        return this.handle(SipMethod.INVITE);
    }

    public Representation invite(Representation representation) throws ResourceException {
        return this.handle(SipMethod.INVITE, representation);
    }

    public Representation notify(Representation representation) throws ResourceException {
        return this.handle(SipMethod.NOTIFY, representation);
    }

    public Representation options() throws ResourceException {
        return this.handle(SipMethod.OPTIONS);
    }

    public void publish() throws ResourceException {
        this.handle(SipMethod.PUBLISH);
    }

    public void publish(Representation representation) throws ResourceException {
        this.handle(SipMethod.PUBLISH, representation);
    }

    public void refer() throws ResourceException {
        this.handle(SipMethod.REFER);
    }

    public void register() throws ResourceException {
        this.handle(SipMethod.REGISTER);
    }

    public void register(Address to) throws ResourceException {
        SipInboundRequest request = (SipInboundRequest)this.getRequest();
        request.setTo(to);
        this.handle(SipMethod.REGISTER);
    }

    public void setCallId(String callId) {
        this.getRequest().setCallId(callId);
    }

    public void setCommandSequence(String commandSequence) {
        this.getRequest().setCommandSequence(commandSequence);
    }

    public void setFrom(Address from) {
        this.getRequest().setFrom(from);
    }

    public void setRequest(Request request) {
        if (!(request instanceof SipRequest)) {
            throw new IllegalArgumentException("Only SipRequest instances are allowed as parameter");
        }
        super.setRequest(request);
    }

    public void setRequestCallId(String callId) {
        this.getRequest().setCallId(callId);
    }

    public void setResponse(Response response) {
        if (!(response instanceof SipResponse)) {
            throw new IllegalArgumentException("Only SipResponse instances are allowed as parameter");
        }
        super.setResponse(response);
    }

    public void setTo(Address to) {
        this.getRequest().setTo(to);
    }

    public void subscribe() throws ResourceException {
        this.handle(SipMethod.SUBSCRIBE);
    }

    public void subscribe(Representation representation) throws ResourceException {
        this.handle(SipMethod.SUBSCRIBE, representation);
    }
}

