/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.restlet.Connector;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.WritableSelectionChannel;
import org.restlet.ext.ssl.internal.ReadableSslChannel;
import org.restlet.ext.ssl.internal.SslUtils;
import org.restlet.ext.ssl.internal.WritableSslChannel;

public class SslConnection<T extends Connector>
extends Connection<T> {
    private volatile InetSocketAddress peerAddress;
    private volatile SSLEngine sslEngine;
    private volatile SSLEngineResult sslEngineResult;

    public SslConnection(ConnectionHelper<T> helper, SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress, SSLEngine sslEngine) throws IOException {
        super(helper, socketChannel, controller, socketAddress, sslEngine.getSession().getApplicationBufferSize(), sslEngine.getSession().getApplicationBufferSize());
        this.sslEngine = sslEngine;
        this.sslEngineResult = null;
        this.getSslEngine().setUseClientMode(this.isClientSide());
        this.initSslEngine();
    }

    protected ReadableSelectionChannel createReadableSelectionChannel() {
        return new ReadableSslChannel(super.createReadableSelectionChannel(), this, this.getRegistration().getWakeupListener());
    }

    protected WritableSelectionChannel createWritableSelectionChannel() {
        return new WritableSslChannel(super.createWritableSelectionChannel(), this, this.getRegistration().getWakeupListener());
    }

    public int getApplicationBufferSize() {
        return this.getSslSession() == null ? 0 : this.getSslSession().getApplicationBufferSize();
    }

    public int getInboundBufferSize() {
        return Math.max(super.getInboundBufferSize(), this.getSslSession().getApplicationBufferSize());
    }

    public int getOutboundBufferSize() {
        return Math.max(super.getOutboundBufferSize(), this.getSslSession().getApplicationBufferSize());
    }

    public int getPacketBufferSize() {
        return this.getSslSession() == null ? 0 : this.getSslSession().getPacketBufferSize();
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public String getSslCipherSuite() {
        SSLSession sslSession = this.getSslSession();
        if (sslSession != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSession sslSession = this.getSslSession();
        if (sslSession != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public SSLEngineResult getSslEngineResult() {
        return this.sslEngineResult;
    }

    public SSLEngineResult.Status getSslEngineStatus() {
        return this.getSslEngineResult() == null ? SSLEngineResult.Status.OK : this.getSslEngineResult().getStatus();
    }

    public SSLEngineResult.HandshakeStatus getSslHandshakeStatus() {
        return this.getSslEngineResult() == null ? this.getSslEngine().getHandshakeStatus() : this.getSslEngineResult().getHandshakeStatus();
    }

    public Integer getSslKeySize() {
        Integer keySize = null;
        String sslCipherSuite = this.getSslCipherSuite();
        if (sslCipherSuite != null) {
            keySize = SslUtils.extractKeySize(sslCipherSuite);
        }
        return keySize;
    }

    public SSLSession getSslSession() {
        return this.getSslEngine() == null ? null : this.getSslEngine().getSession();
    }

    private void handleSslHandshake() throws IOException {
        SSLEngineResult.HandshakeStatus hs = this.getSslHandshakeStatus();
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "Handling SSL handshake: " + (Object)((Object)hs));
        }
        if (hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (this.getSslHandshakeStatus()) {
                case FINISHED: {
                    this.onFinished();
                    break;
                }
                case NEED_TASK: {
                    this.onNeedTask();
                    break;
                }
                case NEED_UNWRAP: {
                    this.onUnwrap();
                    break;
                }
                case NEED_WRAP: {
                    this.onWrap();
                    break;
                }
            }
        }
    }

    public synchronized void handleSslResult() throws IOException {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "Handling SSL result: " + (Object)((Object)this.getSslEngineStatus()));
        }
        switch (this.getSslEngineStatus()) {
            case BUFFER_OVERFLOW: {
                if (!this.getLogger().isLoggable(Level.FINER)) break;
                this.getLogger().log(Level.FINER, "SSL buffer overflow state detected. Application buffer needs to be consumed or compacted before retrying.");
                break;
            }
            case BUFFER_UNDERFLOW: {
                if (this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "SSL buffer underflow state detected. Network buffer needs to be consumed or compacted before retrying.");
                }
                if (this.getSslHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.getInboundWay().getIoState() != IoState.IDLE && this.getInboundWay().getIoState() != IoState.READY) break;
                this.getInboundWay().setIoState(IoState.INTEREST);
                break;
            }
            case CLOSED: {
                this.close(true);
                break;
            }
            case OK: {
                this.handleSslHandshake();
            }
        }
        this.setSslEngineResult(null);
    }

    public void initSslEngine() throws SSLException {
        this.getSslEngine().beginHandshake();
    }

    public boolean isSslHandshaking() {
        return this.getSslHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private void onFinished() {
        if (this.isClientSide()) {
            this.getInboundWay().setIoState(IoState.IDLE);
            this.getOutboundWay().setIoState(IoState.INTEREST);
        } else {
            this.getInboundWay().setIoState(IoState.INTEREST);
            this.getOutboundWay().setIoState(IoState.IDLE);
        }
    }

    private void onNeedTask() {
        final Runnable task = this.getSslEngine().getDelegatedTask();
        if (task != null) {
            this.getInboundWay().setIoState(IoState.IDLE);
            this.getOutboundWay().setIoState(IoState.IDLE);
            this.getHelper().getWorkerService().execute(new Runnable(){

                @Override
                public void run() {
                    SslConnection.this.getLogger().log(Level.FINER, "Running delegated tasks...");
                    task.run();
                    Runnable nextTask = SslConnection.this.getSslEngine().getDelegatedTask();
                    while (nextTask != null) {
                        nextTask.run();
                        nextTask = SslConnection.this.getSslEngine().getDelegatedTask();
                    }
                    if (SslConnection.this.getLogger().isLoggable(Level.FINER)) {
                        SslConnection.this.getLogger().log(Level.FINER, "Done running delegated tasks");
                    }
                    try {
                        SslConnection.this.handleSslResult();
                    }
                    catch (IOException e) {
                        SslConnection.this.getLogger().log(Level.INFO, "Unable to handle SSL handshake", e);
                    }
                    SslConnection.this.getHelper().getController().wakeup();
                }
            });
        }
    }

    private void onUnwrap() throws IOException {
        this.getOutboundWay().setIoState(IoState.IDLE);
        if (this.getInboundWay().getIoState() != IoState.PROCESSING) {
            this.getInboundWay().setIoState(IoState.READY);
        }
    }

    private void onWrap() throws IOException {
        this.getInboundWay().setIoState(IoState.IDLE);
        if (this.getOutboundWay().getIoState() == IoState.IDLE) {
            this.getOutboundWay().setIoState(IoState.READY);
        }
    }

    public void reuse(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        this.setPeerAddress(socketAddress);
        this.initSslEngine();
        super.reuse(socketChannel, controller, socketAddress);
    }

    public void setPeerAddress(InetSocketAddress peerAddress) {
        this.peerAddress = peerAddress;
    }

    public void setSslEngine(SSLEngine engine) {
        this.sslEngine = engine;
    }

    protected void setSslEngineResult(SSLEngineResult engineResult) {
        this.sslEngineResult = engineResult;
    }

    public void setSslResult(SSLEngineResult sslResult) throws IOException {
        if (sslResult != null) {
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "SSL engine result: " + sslResult);
                this.getLogger().log(Level.FINER, "SSL connection: " + this.toString());
            }
            this.setSslEngineResult(sslResult);
        }
    }

    protected void shutdown(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            super.shutdown(socket);
        }
    }

    public String toString() {
        return super.toString() + " | " + this.getSslEngine() + " | " + this.getSslEngineResult();
    }
}

