/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.util.FormReader;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUtils {
    public static Parameter create(CharSequence name, CharSequence value, boolean decode, CharacterSet characterSet) {
        Parameter result = null;
        if (name != null) {
            String nameStr = decode ? Reference.decode(((Object)name).toString(), characterSet) : ((Object)name).toString();
            if (value != null) {
                String valueStr = decode ? Reference.decode(((Object)value).toString(), characterSet) : ((Object)value).toString();
                result = new Parameter(nameStr, valueStr);
            } else {
                result = new Parameter(nameStr, null);
            }
        }
        return result;
    }

    public static Parameter getFirstParameter(Representation post, String name) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(post).readFirstParameter(name);
    }

    public static Parameter getFirstParameter(String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(query, characterSet, separator).readFirstParameter(name);
    }

    public static Object getParameter(Representation form, String name) throws IOException {
        if (!form.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(form).readParameter(name);
    }

    public static Object getParameter(String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(query, characterSet, separator).readParameter(name);
    }

    public static void getParameters(Representation post, Map<String, Object> parameters) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        new FormReader(post).readParameters(parameters);
    }

    public static void getParameters(String parametersString, Map<String, Object> parameters, CharacterSet characterSet, char separator) throws IOException {
        new FormReader(parametersString, characterSet, separator).readParameters(parameters);
    }

    public static boolean isParameterFound(Parameter searchedParam, MediaType mediaRange) {
        boolean result = false;
        Iterator iter = mediaRange.getParameters().iterator();
        while (!result && iter.hasNext()) {
            result = searchedParam.equals(iter.next());
        }
        return result;
    }

    public static void parse(Form form, Representation post) {
        if (post != null) {
            if (post.isAvailable()) {
                FormReader fr = null;
                try {
                    fr = new FormReader(post);
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to create a form reader. Parsing aborted.", ioe);
                }
                if (fr != null) {
                    fr.addParameters(form);
                }
            } else {
                throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
            }
        }
    }

    public static void parse(Form form, String parametersString, CharacterSet characterSet, boolean decode, char separator) {
        if (parametersString != null && !parametersString.equals("")) {
            FormReader fr = null;
            fr = decode ? new FormReader(parametersString, characterSet, separator) : new FormReader(parametersString, separator);
            fr.addParameters(form);
        }
    }

    private FormUtils() {
    }
}

