/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Status;
import org.restlet.security.Authenticator;
import org.restlet.security.Verifier;

public class ChallengeAuthenticator
extends Authenticator {
    private volatile String realm;
    private volatile boolean rechallenging;
    private final ChallengeScheme scheme;
    private volatile Verifier verifier;

    public ChallengeAuthenticator(Context context, boolean optional, ChallengeScheme challengeScheme, String realm) {
        this(context, optional, challengeScheme, realm, context != null ? context.getDefaultVerifier() : null);
    }

    public ChallengeAuthenticator(Context context, boolean optional, ChallengeScheme challengeScheme, String realm, Verifier verifier) {
        super(context, optional);
        this.realm = realm;
        this.rechallenging = true;
        this.scheme = challengeScheme;
        this.verifier = verifier;
    }

    public ChallengeAuthenticator(Context context, ChallengeScheme challengeScheme, String realm) {
        this(context, false, challengeScheme, realm);
    }

    protected boolean authenticate(Request request, Response response) {
        boolean result = false;
        boolean loggable = this.getLogger().isLoggable(Level.FINE);
        if (this.getVerifier() != null) {
            switch (this.getVerifier().verify(request, response)) {
                case 4: {
                    result = true;
                    if (!loggable) break;
                    ChallengeResponse challengeResponse = request.getChallengeResponse();
                    if (challengeResponse != null) {
                        this.getLogger().fine("Authentication succeeded. Valid credentials provided for identifier: " + request.getChallengeResponse().getIdentifier() + ".");
                        break;
                    }
                    this.getLogger().fine("Authentication succeeded. Valid credentials provided.");
                    break;
                }
                case 0: {
                    if (loggable) {
                        this.getLogger().fine("Authentication failed. No credentials provided.");
                    }
                    if (this.isOptional()) break;
                    this.challenge(response, false);
                    break;
                }
                case -1: {
                    if (loggable) {
                        this.getLogger().fine("Authentication failed. Invalid credentials provided.");
                    }
                    if (this.isOptional()) break;
                    if (this.isRechallenging()) {
                        this.challenge(response, false);
                        break;
                    }
                    this.forbid(response);
                    break;
                }
                case 1: {
                    if (loggable) {
                        this.getLogger().fine("Authentication failed. Stale credentials provided.");
                    }
                    if (this.isOptional()) break;
                    this.challenge(response, true);
                    break;
                }
                case 5: {
                    if (loggable) {
                        this.getLogger().fine("Authentication failed. Identifier is unknown.");
                    }
                    if (this.isOptional()) break;
                    if (this.isRechallenging()) {
                        this.challenge(response, false);
                        break;
                    }
                    this.forbid(response);
                }
            }
        } else {
            this.getLogger().warning("Authentication failed. No verifier provided.");
        }
        return result;
    }

    public void challenge(Response response, boolean stale) {
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        response.getChallengeRequests().add(this.createChallengeRequest(stale));
    }

    protected ChallengeRequest createChallengeRequest(boolean stale) {
        return new ChallengeRequest(this.getScheme(), this.getRealm());
    }

    public void forbid(Response response) {
        response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
    }

    public String getRealm() {
        return this.realm;
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public boolean isRechallenging() {
        return this.rechallenging;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setRechallenging(boolean rechallenging) {
        this.rechallenging = rechallenging;
    }

    public void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }
}

